set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5907249';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2330',
      NULL,
      '12334401',
      '03334022',
      '33221204',
      '42301004',
      '33201110',
      '34001421',
      '41423013',
      '31104342',
      '34230000',
      NULL,
      '34344200',
      NULL,
      '21312144',
      '10111113',
      '10204213',
      '20203242',
      NULL,
      '00402200',
      NULL,
      '13040110',
      '03213334',
      '12121144',
      '23232004',
      '30043043',
      '20220340',
      '00133241',
      '03001101',
      '32433221',
      NULL,
      '10124103',
      '32430040',
      NULL,
      '43302343',
      '20142043',
      '24234212',
      '02012004',
      NULL,
      '01124034',
      '33300043',
      '00203441',
      '42444421',
      NULL,
      '14432212',
      '',
      '',
      NULL,
      NULL,
      '0224023',
      NULL,
      0,
      0,
      NULL,
      '110331',
      1,
      ' 2-14-1994',
      ' 5- 6-1999',
      71.208088,
      NULL,
      42.267011,
      11,
      9,
      4.407792,
      NULL,
      15.002714,
      2.908033,
      NULL,
      13.351184,
      25,
      1,
      17.990049,
      NULL,
      8.912317,
      NULL,
      NULL,
      17.306313,
      17,
      NULL,
      7,
      NULL,
      6,
      NULL,
      120.294167,
      NULL,
      86,
      NULL,
      211.826426,
      72,
      ' 7-24-1999',
      38,
      NULL,
      3,
      15,
      27.034941,
      64,
      ' 1-18-1979',
      1.990398,
      9.387757,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10.978832,
      1.877186,
      1.975256,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-16-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-17-1975',
      97,
      NULL,
      34.419241,
      121,
      68.820201,
      21,
      68.936742,
      NULL,
      100,
      NULL,
      65,
      15.523030,
      ' 9-17-1993',
      NULL,
      0.844439,
      6.926092,
      16,
      36.048383,
      58,
      NULL,
      ' 6-27-1977',
      13.598558,
      NULL,
      ' 9-10-1997',
      5.306827,
      0,
      10,
      5,
      3,
      1,
      NULL,
      17,
      NULL,
      NULL,
      3.292263,
      2.404173,
      13,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-27-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      36.587291,
      NULL,
      0,
      ' 9- 9-2001',
      1.997188,
      109,
      NULL,
      7.102337,
      82.926073,
      18.398063,
      NULL,
      ' 3-10-1983',
      46,
      0,
      190,
      ' 9-19-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      111,
      110,
      NULL,
      NULL,
      NULL,
      21.431836,
      5.520734,
      4.875180,
      4.762817,
      13.027224,
      NULL,
      NULL,
      1.973177,
      NULL,
      0.006514,
      1,
      0.472640,
      0.999957,
      4.574483,
      NULL,
      2.544044,
      9.841176,
      83.069825,
      NULL,
      9,
      NULL,
      0.369835,
      NULL,
      0,
      1.662944,
      0.165570,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      0.975456,
      21,
      1.883043,
      1.295345,
      1,
      1.834392,
      NULL,
      NULL,
      3,
      NULL,
      1.193008,
      1.999731,
      NULL,
      NULL,
      NULL,
      25,
      NULL,
      NULL,
      29.578752,
      NULL,
      10.820958,
      3,
      1.636957,
      1,
      NULL,
      0,
      1.696073,
      0.478590,
      NULL,
      ' 7-19-1983',
      '11- 5-1982',
      ' 8-19-1991',
      '11-29-1987',
      ' 9-16-1988',
      ' 6- 0-1994',
      ' 1-22-1990',
      NULL);
commit;
end;
/


