set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9827986';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      NULL,
      '1',
      NULL,
      NULL,
      '2',
      '0',
      '4',
      '2',
      '4',
      '2',
      '4',
      '3',
      '1',
      '3',
      NULL,
      '2',
      '1',
      '1',
      '0',
      '3',
      '0',
      '0',
      '1',
      NULL,
      NULL,
      '',
      '0',
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '',
      '2',
      '0',
      '3',
      '3',
      NULL,
      '0',
      '4',
      NULL,
      '0',
      '4',
      '3',
      NULL,
      '41023130',
      7,
      69,
      '3232323',
      3.646039,
      0,
      NULL,
      NULL,
      '234441',
      NULL,
      ' 9- 2-1987',
      '11- 1-1989',
      44.543972,
      13.426981,
      29,
      20.957761,
      NULL,
      11.895476,
      44,
      29.636016,
      NULL,
      3,
      32.788134,
      NULL,
      NULL,
      NULL,
      4.284257,
      17,
      31,
      NULL,
      42.596926,
      5.850352,
      31.796981,
      13,
      95.210182,
      NULL,
      1.979324,
      101,
      105,
      51,
      NULL,
      28.448488,
      215,
      '10- 1-1982',
      66.901373,
      NULL,
      18,
      34,
      NULL,
      207,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      96,
      2.842210,
      3.580331,
      NULL,
      2.396082,
      NULL,
      ' 5- 2-1978',
      1,
      0.916497,
      NULL,
      0,
      1,
      68,
      1.826090,
      1.900508,
      103.598179,
      NULL,
      NULL,
      NULL,
      ' 7- 6-2002',
      109.611988,
      NULL,
      20.492138,
      NULL,
      26.571173,
      35,
      80.606367,
      37.426218,
      NULL,
      NULL,
      77,
      10,
      NULL,
      11,
      8.394010,
      5.115286,
      48.724459,
      NULL,
      76,
      2,
      ' 7- 2-1984',
      NULL,
      27,
      NULL,
      0,
      2,
      6,
      5.037935,
      24,
      NULL,
      1.865060,
      20.644207,
      NULL,
      30.337078,
      NULL,
      8.721615,
      3,
      8,
      1.918662,
      3,
      3.585120,
      0.909785,
      ' 9-16-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      87,
      2.225270,
      ' 1-18-1993',
      NULL,
      NULL,
      NULL,
      4,
      ' 1- 7-1989',
      1.476020,
      NULL,
      11.696991,
      13.386018,
      NULL,
      NULL,
      139.150847,
      ' 2- 9-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      10.112593,
      ' 0-14-1979',
      55.773931,
      41.760859,
      4,
      ' 6-23-1982',
      1,
      NULL,
      ' 2- 0-2002',
      2,
      0.820834,
      NULL,
      4,
      '11-18-1991',
      40,
      1.922704,
      108.715971,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


