set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9851628';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '3',
      '3',
      '1',
      '2',
      '2',
      NULL,
      '3',
      '3',
      '3',
      '2',
      NULL,
      '3',
      '1',
      NULL,
      '4',
      '4',
      '0',
      '0',
      '1',
      '1',
      '2',
      '1',
      NULL,
      '',
      '1',
      '',
      NULL,
      '4',
      '3',
      '3',
      '0',
      NULL,
      '',
      '2',
      '0',
      '2',
      '2',
      '3',
      '0',
      '1',
      '2',
      NULL,
      '1',
      '1',
      '322',
      '30144213',
      2.401984,
      26.514374,
      NULL,
      NULL,
      0.755074,
      2,
      NULL,
      '002202',
      2.676473,
      ' 9-15-1993',
      NULL,
      24.235190,
      254,
      10.961359,
      8.445344,
      23,
      NULL,
      14,
      NULL,
      NULL,
      17.493902,
      17.050977,
      10.055419,
      12,
      10,
      30,
      10,
      3,
      19.162501,
      72.593957,
      9,
      NULL,
      5.966942,
      27,
      NULL,
      NULL,
      62,
      37,
      8,
      135.103548,
      103.935819,
      42.345537,
      ' 3- 0-1996',
      48.356609,
      13,
      10.655615,
      18,
      11,
      134,
      ' 2-20-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      68,
      NULL,
      NULL,
      7.361281,
      7,
      6,
      ' 4- 8-1978',
      2,
      3.966867,
      2,
      1.998601,
      0.778070,
      69,
      1,
      1.854966,
      55,
      NULL,
      NULL,
      NULL,
      ' 7-10-1984',
      126.891117,
      74.861472,
      NULL,
      86,
      83.769356,
      NULL,
      NULL,
      88,
      61.822239,
      NULL,
      76,
      4.692811,
      ' 6-24-2000',
      27.190341,
      25.252249,
      NULL,
      40.532645,
      95,
      52,
      6.003426,
      NULL,
      NULL,
      20.268873,
      ' 5- 2-1990',
      NULL,
      NULL,
      25.468030,
      17,
      19.937324,
      15,
      NULL,
      22.498627,
      1,
      NULL,
      0,
      0,
      17.552709,
      19,
      0.874748,
      1.957830,
      0.504828,
      1.316993,
      ' 0-10-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      48,
      5,
      ' 0-16-1996',
      NULL,
      NULL,
      NULL,
      54,
      NULL,
      41.350778,
      ' 0-28-1979',
      5.883195,
      NULL,
      ' 2- 1-1998',
      NULL,
      78,
      ' 4-12-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      ' 1-21-1974',
      22.107579,
      14,
      22.309235,
      ' 4-25-1974',
      1.464914,
      76.526323,
      NULL,
      7.728638,
      NULL,
      13.350487,
      6,
      ' 7-28-1986',
      49.840345,
      1.998417,
      47,
      ' 3- 1-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


