set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9208748';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1121',
      NULL,
      '04102021',
      '13100010',
      '04202044',
      '41431123',
      '42233111',
      NULL,
      '20031140',
      '31020141',
      '04444343',
      '32041402',
      '21344401',
      '33241042',
      '22000214',
      '44231312',
      '14213002',
      NULL,
      '31432142',
      '10431043',
      '11411104',
      NULL,
      '30012202',
      '20310323',
      NULL,
      '01044433',
      '40202031',
      '03442423',
      '14431013',
      '04414143',
      '44220112',
      NULL,
      '21043400',
      '40102101',
      '14032422',
      '33233304',
      '40443102',
      '01403400',
      NULL,
      NULL,
      '21304041',
      NULL,
      '34314302',
      NULL,
      '43233411',
      '013',
      '10',
      19.503409,
      8,
      '2340220',
      2,
      0.550917,
      2,
      NULL,
      '431023',
      3.300936,
      ' 3-27-1992',
      NULL,
      36,
      95,
      31.897664,
      19.520094,
      NULL,
      13.628840,
      18.863644,
      5,
      21.786880,
      16.690461,
      31.889358,
      17.098490,
      11.526913,
      1.298327,
      22.994577,
      12,
      7,
      4.607191,
      0.342742,
      NULL,
      63,
      17,
      63,
      24,
      NULL,
      100,
      84,
      27,
      85.702231,
      119.774262,
      209,
      ' 6-23-1985',
      29,
      66.138083,
      18.028962,
      5,
      53.266753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17,
      NULL,
      8.211310,
      11,
      11.724260,
      ' 6-26-1997',
      1,
      0,
      85.009821,
      0.928937,
      0.924877,
      118,
      3.677962,
      NULL,
      92,
      NULL,
      NULL,
      NULL,
      ' 8-18-1997',
      102.357335,
      NULL,
      57,
      59.611550,
      30.293668,
      38,
      109,
      47.448732,
      NULL,
      NULL,
      NULL,
      7,
      ' 0- 9-1987',
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0,
      8.069821,
      ' 5-16-1985',
      12.841942,
      22,
      ' 2-17-1981',
      NULL,
      4,
      12.258864,
      NULL,
      15.099672,
      2,
      0.405990,
      8.340483,
      1.642602,
      109,
      0,
      3,
      5.093370,
      NULL,
      3,
      1,
      0,
      1.393569,
      ' 2-16-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8.333920,
      ' 7-24-1992',
      NULL,
      NULL,
      NULL,
      44,
      NULL,
      43.391630,
      ' 3-13-1974',
      NULL,
      13.628149,
      ' 4- 9-1979',
      72,
      41.013168,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      18,
      ' 0- 7-1989',
      59.118368,
      42.077652,
      54.021986,
      NULL,
      0,
      22.248773,
      '11- 8-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


