set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7101619';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      '0',
      NULL,
      '3',
      '2',
      '0',
      '4',
      '0',
      '2',
      '4',
      '2',
      NULL,
      '3',
      '1',
      '0',
      '4',
      '0',
      '4',
      '3',
      NULL,
      NULL,
      '0',
      NULL,
      '',
      '0',
      '',
      NULL,
      '2',
      '3',
      '3',
      NULL,
      NULL,
      '',
      NULL,
      '3',
      '2',
      NULL,
      '0',
      '1',
      '3',
      '3',
      '3',
      NULL,
      '4',
      NULL,
      '34234440',
      35,
      NULL,
      '4103443',
      1.014697,
      1,
      2,
      0,
      '134131',
      1,
      ' 9- 5-1979',
      '11-17-1992',
      252,
      84.776897,
      22.003793,
      1,
      20.615798,
      14,
      27.177609,
      25.345984,
      NULL,
      NULL,
      NULL,
      0,
      4,
      8.631510,
      0.604149,
      3.115903,
      2.153769,
      8,
      26,
      9.371336,
      NULL,
      15.803646,
      64,
      4.561874,
      0.143862,
      3,
      33,
      23.926725,
      31.707447,
      126,
      44,
      NULL,
      68.928265,
      58.635815,
      28.298385,
      30,
      171,
      156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      49.886255,
      NULL,
      NULL,
      16,
      13,
      3,
      ' 4-23-1978',
      1,
      1,
      73,
      1.117142,
      NULL,
      123,
      0.592552,
      0.281608,
      33.811630,
      NULL,
      NULL,
      NULL,
      ' 4-29-1977',
      NULL,
      93.852460,
      106,
      13,
      24,
      NULL,
      81,
      NULL,
      NULL,
      NULL,
      NULL,
      43,
      NULL,
      12.703925,
      28,
      NULL,
      83,
      90,
      NULL,
      7.512481,
      ' 7-17-1979',
      NULL,
      3,
      ' 4- 7-1977',
      0,
      NULL,
      NULL,
      18,
      20.329542,
      8,
      0.419763,
      0.181746,
      0,
      6.941335,
      3,
      1,
      NULL,
      7,
      2.248532,
      3,
      3.047899,
      NULL,
      ' 2-22-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      23,
      5,
      ' 9-22-1985',
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      16,
      ' 9-20-1990',
      NULL,
      9.728069,
      ' 7-11-1982',
      NULL,
      90.874161,
      ' 4- 2-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      14.058218,
      NULL,
      20.219192,
      34.742198,
      6,
      NULL,
      1,
      39.342916,
      ' 0- 8-1975',
      NULL,
      32.946399,
      23,
      55.241632,
      ' 5- 1-1986',
      63.250670,
      0,
      63.639081,
      ' 9-16-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


