set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0122054';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '1',
      '1',
      '0',
      '4',
      '0',
      '3',
      '3',
      '2',
      '0',
      NULL,
      '1',
      '4',
      '1',
      '0',
      '3',
      '0',
      '3',
      '4',
      '2',
      '2',
      '4',
      '0',
      '4',
      '',
      '2',
      '',
      '4',
      '2',
      NULL,
      '0',
      '2',
      '',
      NULL,
      NULL,
      NULL,
      '4',
      '0',
      '1',
      '3',
      '4',
      NULL,
      '4',
      '4',
      '3',
      '442',
      '32034000',
      14.539014,
      8,
      NULL,
      3.426974,
      0.674013,
      3,
      1,
      '440313',
      3.205920,
      ' 8- 7-1985',
      '10- 6-1999',
      NULL,
      47.562483,
      15,
      5.462903,
      20.687335,
      11.338708,
      91.908927,
      NULL,
      14.941251,
      28,
      NULL,
      22,
      38,
      14,
      23,
      15,
      NULL,
      3,
      42.978979,
      7,
      3.619465,
      1,
      5.957775,
      11.427661,
      NULL,
      NULL,
      135,
      58.592401,
      NULL,
      120,
      163.716258,
      ' 7-12-1989',
      NULL,
      66,
      24,
      10,
      202,
      216,
      ' 6-11-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16.546677,
      NULL,
      3,
      NULL,
      3.375635,
      '10- 0-1986',
      1.728134,
      0,
      118,
      1.021369,
      1.877282,
      74.620091,
      1,
      1.774458,
      122,
      NULL,
      NULL,
      NULL,
      NULL,
      58,
      75.537520,
      44.646545,
      101,
      37.647950,
      91.530870,
      2,
      48,
      4.195544,
      81,
      25.454582,
      7,
      '10-20-1993',
      54,
      31.999519,
      2.817000,
      81.140324,
      11,
      121,
      0,
      ' 9- 0-2001',
      11,
      18,
      ' 2- 8-1988',
      NULL,
      NULL,
      NULL,
      5.228265,
      NULL,
      NULL,
      NULL,
      8,
      1,
      NULL,
      NULL,
      4.800949,
      2,
      NULL,
      1.885410,
      1.270607,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      179.388885,
      2,
      ' 1- 1-1989',
      NULL,
      NULL,
      NULL,
      33.846321,
      ' 2-28-2001',
      NULL,
      ' 3- 1-2000',
      8,
      11,
      ' 2-28-1999',
      14.486965,
      127.020867,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      13.436076,
      ' 1-25-1978',
      34.189502,
      40.586294,
      2,
      ' 2-12-1999',
      NULL,
      14,
      ' 2-19-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


