set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9757901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      NULL,
      '1',
      '0',
      '4',
      '1',
      '4',
      '4',
      NULL,
      '4',
      '3',
      '0',
      '2',
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      '3',
      '3',
      '0',
      NULL,
      '0',
      NULL,
      NULL,
      '1',
      NULL,
      '1',
      NULL,
      '3',
      '2',
      '1',
      '',
      '',
      '1',
      '0',
      '3',
      '3',
      '2',
      '3',
      '3',
      NULL,
      '2',
      '1',
      '1',
      '013',
      '14404432',
      1.606553,
      36.889728,
      '1331202',
      0,
      NULL,
      3,
      NULL,
      '100314',
      4.305605,
      ' 5- 4-1980',
      ' 7-20-1994',
      35,
      NULL,
      14.240626,
      11,
      1,
      11,
      50.523034,
      10.233228,
      37.569712,
      12,
      2,
      4,
      42.489979,
      21.980001,
      25.441620,
      NULL,
      26.342755,
      NULL,
      NULL,
      22,
      37.987786,
      1.513188,
      147.023118,
      18.044169,
      0.669480,
      54.186205,
      11.488930,
      64,
      132.414095,
      210.736076,
      81,
      ' 8- 4-1997',
      36.355656,
      55,
      28.419576,
      NULL,
      NULL,
      53.454960,
      ' 1- 3-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      114,
      NULL,
      5,
      5.424276,
      NULL,
      11.678448,
      ' 2- 0-1977',
      NULL,
      1.808282,
      184,
      1.070113,
      0,
      33,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      32.683692,
      6.090772,
      78.381838,
      43.794339,
      39.532022,
      85,
      64.917326,
      NULL,
      68,
      6.013360,
      26.481349,
      0.520594,
      ' 2-17-1986',
      3.807157,
      11.552606,
      4.872692,
      11.049552,
      35.698364,
      76,
      0.183673,
      ' 3- 8-1993',
      29.552255,
      13,
      ' 6-18-1986',
      NULL,
      10,
      NULL,
      7.906134,
      29.425592,
      NULL,
      1,
      NULL,
      NULL,
      25.855428,
      1,
      NULL,
      8.455252,
      NULL,
      NULL,
      NULL,
      1,
      1,
      ' 3-16-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      41.199008,
      NULL,
      ' 9-23-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-12-2003',
      NULL,
      ' 3-28-1995',
      11.793271,
      18,
      ' 4-19-1999',
      9.688340,
      89,
      ' 2-11-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      24,
      ' 5-15-1995',
      60.609427,
      17,
      1.146275,
      ' 8-12-1976',
      NULL,
      40,
      ' 5-15-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


