set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8111275';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '4',
      '4',
      NULL,
      NULL,
      '0',
      NULL,
      '1',
      NULL,
      '2',
      NULL,
      '1',
      '4',
      '3',
      '0',
      '4',
      '1',
      '3',
      '1',
      '0',
      '1',
      '4',
      '3',
      NULL,
      '',
      '1',
      '',
      '2',
      NULL,
      NULL,
      '3',
      '3',
      '',
      '',
      '3',
      '4',
      '3',
      NULL,
      '3',
      '3',
      '3',
      '2',
      '4',
      '4',
      '1',
      '421',
      '01013244',
      NULL,
      0,
      '2413230',
      0.443792,
      1.371179,
      0,
      NULL,
      NULL,
      1.007195,
      '11-27-1992',
      ' 9-28-1999',
      0.522122,
      62.561075,
      12.780969,
      NULL,
      19.493310,
      8,
      20.927167,
      NULL,
      NULL,
      8.705473,
      12.034188,
      7,
      28.652178,
      1,
      18.643826,
      NULL,
      8.974156,
      9,
      84.719765,
      14,
      26,
      23.192649,
      29,
      1.653996,
      0.374061,
      3.680971,
      132,
      81.375849,
      20,
      62.445439,
      71.894722,
      ' 5-20-1977',
      NULL,
      NULL,
      3,
      8.825582,
      178,
      NULL,
      ' 3-10-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      11,
      NULL,
      NULL,
      0.443766,
      '11- 7-2002',
      0,
      NULL,
      60,
      0.542136,
      NULL,
      68,
      1.941509,
      1.432138,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-18-1991',
      NULL,
      64,
      41,
      54.874508,
      67,
      48,
      53.260799,
      83,
      81,
      41.707169,
      NULL,
      61.137850,
      '11- 5-1999',
      17,
      2,
      3,
      11.868488,
      1.411229,
      123.214435,
      7.093819,
      ' 6-14-2002',
      3.475623,
      17.525684,
      ' 9-11-1992',
      12.582828,
      11.201101,
      NULL,
      9,
      0,
      NULL,
      NULL,
      10.869309,
      NULL,
      1,
      7,
      NULL,
      NULL,
      18,
      2,
      0,
      1,
      0,
      ' 7-25-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      ' 3- 3-2002',
      NULL,
      NULL,
      NULL,
      13.345371,
      ' 8-10-1981',
      9,
      ' 5-29-1989',
      11.928457,
      3,
      ' 1-28-2002',
      34,
      50,
      ' 6- 0-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      19,
      NULL,
      NULL,
      23,
      10.386495,
      NULL,
      1,
      110,
      NULL,
      2,
      24.996782,
      NULL,
      25,
      ' 9- 1-2002',
      19,
      1.199047,
      174.109476,
      ' 2-20-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


