set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228662';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2110',
      NULL,
      '10120004',
      '30313314',
      NULL,
      '11332144',
      '24113023',
      '44044203',
      '20414002',
      '24023203',
      '41132344',
      '11313241',
      '02144010',
      '23132340',
      '02221222',
      NULL,
      NULL,
      '31101311',
      '10012201',
      '43422341',
      '20421340',
      '13123144',
      NULL,
      '02214202',
      '30044031',
      NULL,
      NULL,
      '20404003',
      '32143322',
      NULL,
      '10112442',
      '41042342',
      '42422321',
      '10032021',
      '32103400',
      '21011310',
      '40330402',
      '22433212',
      NULL,
      '44044132',
      '20131201',
      '43314123',
      '32242444',
      '10310331',
      '11131223',
      '421',
      '11',
      NULL,
      NULL,
      '2220112',
      2.161589,
      NULL,
      2,
      NULL,
      '204124',
      0,
      NULL,
      ' 5-21-1995',
      27,
      NULL,
      0,
      14,
      13,
      6,
      NULL,
      NULL,
      18.527513,
      9,
      29.285378,
      4.890088,
      14.659111,
      13,
      19,
      19.595995,
      22,
      NULL,
      29,
      NULL,
      36,
      9,
      29,
      12.022552,
      1.224075,
      NULL,
      8,
      8.925153,
      128.712256,
      119,
      169,
      ' 9-29-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      0.544849,
      2.170571,
      3.094858,
      NULL,
      NULL,
      NULL,
      0.339161,
      0,
      0.715136,
      0,
      1,
      0.205996,
      5,
      0.536397,
      NULL,
      0.491535,
      0,
      1.344873,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-27-1990',
      71,
      26.593688,
      24,
      17.888688,
      4.985422,
      0,
      ' 8-11-1981',
      1,
      1.109559,
      NULL,
      0,
      NULL,
      78.725891,
      0,
      0.513012,
      8,
      0,
      0.819381,
      40.676995,
      '11-22-1998',
      78.975555,
      86.557129,
      118.223419,
      128,
      74,
      62,
      67,
      67,
      15.969637,
      NULL,
      51.380014,
      108.686038,
      ' 9-25-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      9.979609,
      NULL,
      13.172256,
      NULL,
      2,
      5,
      0,
      5,
      0,
      NULL,
      NULL,
      1.861778,
      NULL,
      19.668721,
      2,
      3,
      4,
      0.481837,
      ' 4- 6-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      13.845030,
      NULL,
      ' 2-25-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 9-1988',
      5.046497,
      '11- 9-1977',
      NULL,
      5.896755,
      ' 8-16-1997',
      NULL,
      NULL,
      NULL,
      2,
      0,
      '11- 7-1995',
      1.569886,
      NULL,
      NULL,
      NULL,
      NULL,
      17,
      ' 1-17-1981',
      34.706337,
      29.438207,
      NULL,
      '10-24-2000',
      1,
      NULL,
      ' 5- 9-1992',
      NULL,
      30.048842,
      14,
      55,
      '10- 2-2000',
      69.064193,
      0,
      219.218613,
      ' 8-23-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


