set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228662';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0431',
      '13113343',
      '44331020',
      '22204402',
      '01431103',
      '31300001',
      '33201200',
      '30010320',
      '43422032',
      '22000004',
      '01200442',
      NULL,
      '33012302',
      '21242304',
      '20333400',
      '21403312',
      '43014200',
      '43021020',
      '12334030',
      NULL,
      NULL,
      NULL,
      '24440403',
      '40012241',
      '44012400',
      '04100304',
      '12042013',
      NULL,
      '02231123',
      '00121121',
      '41040430',
      '30310043',
      '11430313',
      '34340322',
      '24221322',
      '10141021',
      NULL,
      '30341323',
      '20212321',
      '01130014',
      '00223221',
      '43424120',
      '11303440',
      '24124013',
      NULL,
      '203',
      '03',
      NULL,
      NULL,
      '4321123',
      3,
      1.660061,
      NULL,
      NULL,
      '323442',
      4,
      '11-24-2000',
      ' 9- 9-2001',
      NULL,
      NULL,
      40.297647,
      8.652343,
      6.978419,
      13,
      26,
      0,
      15,
      4.965360,
      NULL,
      NULL,
      3,
      NULL,
      0.909324,
      NULL,
      3,
      8,
      21.805873,
      1.059099,
      NULL,
      15.216045,
      65.848706,
      2,
      1.351782,
      35.503314,
      27,
      32.820859,
      53,
      104.941731,
      NULL,
      ' 9-13-1993',
      21,
      NULL,
      18,
      4.883623,
      60.443002,
      42,
      '11-10-1981',
      6,
      NULL,
      2,
      1.810975,
      4.811542,
      1,
      0,
      0.543362,
      2.243921,
      1,
      2.699344,
      NULL,
      1.119054,
      NULL,
      1,
      0,
      0.992950,
      1.395322,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-21-1976',
      NULL,
      38.408848,
      NULL,
      10,
      NULL,
      0,
      ' 4-27-1990',
      0.055503,
      1,
      86.467999,
      NULL,
      3.162171,
      0,
      0.668005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-11-2003',
      NULL,
      14,
      78.223539,
      4.572647,
      NULL,
      33.038292,
      10,
      4,
      68,
      45.526130,
      83,
      65.282139,
      '10-29-1983',
      2.259440,
      14,
      5,
      NULL,
      31,
      6.485669,
      NULL,
      ' 4-18-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      107,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      ' 6- 8-1979',
      33,
      ' 3-22-1984',
      11.734336,
      13.446155,
      ' 2-13-1993',
      NULL,
      NULL,
      NULL,
      0,
      0.706540,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.280602,
      ' 7- 4-1974',
      33,
      6,
      NULL,
      ' 3-15-1990',
      2.797492,
      151,
      ' 4-29-1977',
      3,
      13.081748,
      10.498452,
      41.304934,
      ' 6-20-1989',
      13.488101,
      0.240074,
      102.374316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


