set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9809301';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '4',
      '1',
      NULL,
      '3',
      '1',
      '1',
      '3',
      NULL,
      '2',
      '1',
      '1',
      '2',
      '4',
      '2',
      '0',
      NULL,
      '0',
      NULL,
      NULL,
      '3',
      '2',
      NULL,
      '4',
      NULL,
      '2',
      '',
      '4',
      '1',
      NULL,
      '3',
      '2',
      NULL,
      '',
      NULL,
      '0',
      NULL,
      '0',
      '0',
      '3',
      '4',
      '3',
      NULL,
      '3',
      '0',
      '304',
      '21003240',
      NULL,
      19.879890,
      '3321434',
      0,
      1.742824,
      NULL,
      NULL,
      '322314',
      5.487973,
      ' 5-21-1988',
      NULL,
      57.687837,
      207.463157,
      21,
      2.921474,
      18.127300,
      NULL,
      NULL,
      12.681493,
      24,
      NULL,
      25,
      6.853206,
      29,
      6.325105,
      8,
      14,
      9.866282,
      10.163917,
      75.976771,
      23.475852,
      31,
      7.299386,
      NULL,
      3.251196,
      0.130390,
      65,
      15.425895,
      NULL,
      107.829110,
      95,
      163,
      ' 6-28-1994',
      54.561373,
      69,
      2.139000,
      6,
      206,
      233.470419,
      ' 6-21-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      13.989399,
      1.922479,
      6.064407,
      1.530561,
      ' 5-19-1980',
      1.905029,
      0.106766,
      97.305310,
      1,
      0.834923,
      9,
      NULL,
      0.754526,
      13,
      NULL,
      NULL,
      NULL,
      ' 1-25-2001',
      80,
      NULL,
      39.017604,
      55,
      64,
      99.388995,
      50.699630,
      12,
      41.988657,
      NULL,
      10,
      59.505613,
      '10-14-1997',
      30.567435,
      1.539550,
      36.524433,
      NULL,
      16.472056,
      NULL,
      3.915120,
      ' 0- 4-1975',
      11,
      NULL,
      NULL,
      17.369598,
      21,
      20.807280,
      27,
      11,
      3,
      3,
      7,
      0.309246,
      77.800330,
      1,
      1,
      10,
      29.361158,
      1.922332,
      0,
      1.647104,
      0.439260,
      '10-13-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      79,
      0,
      ' 5- 6-2002',
      NULL,
      NULL,
      NULL,
      31.014385,
      NULL,
      1,
      NULL,
      10.449605,
      NULL,
      '10- 5-1978',
      33,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      13,
      '10-26-1999',
      28.270634,
      8.237333,
      21,
      ' 8- 5-1994',
      0.535925,
      26.728776,
      ' 1-28-1979',
      8,
      0.777736,
      17.452505,
      27,
      ' 5-20-1993',
      0.302677,
      NULL,
      68.122417,
      ' 0-26-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


