set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8736368';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '44401340',
      '32211331',
      '41004003',
      '01344442',
      '23324114',
      '31201212',
      '10402310',
      '33332022',
      NULL,
      '44442032',
      '12214144',
      NULL,
      '01423403',
      NULL,
      '21344440',
      '40112413',
      '21211444',
      '03224001',
      '01022322',
      '44004034',
      '00343000',
      '20432040',
      NULL,
      NULL,
      '30043302',
      '32334441',
      NULL,
      '31043433',
      '33410440',
      NULL,
      '41401230',
      '11421432',
      '44434214',
      NULL,
      NULL,
      '12114113',
      '02400044',
      '22412323',
      '43400040',
      NULL,
      '10044122',
      '13221311',
      NULL,
      '41334041',
      '113',
      '00',
      NULL,
      NULL,
      '3203234',
      2.110334,
      0.137162,
      3,
      NULL,
      '331033',
      5,
      '10-12-1996',
      NULL,
      8.758142,
      NULL,
      50,
      NULL,
      23,
      14,
      120.780644,
      27,
      32.953150,
      21,
      NULL,
      13.619449,
      NULL,
      10.704091,
      NULL,
      9.954901,
      26,
      3,
      91,
      30.742612,
      3,
      12,
      99.510920,
      NULL,
      NULL,
      137,
      1,
      53.933967,
      167,
      198,
      212,
      '11- 6-2003',
      1,
      NULL,
      NULL,
      33,
      62.241888,
      NULL,
      NULL,
      0,
      1.495838,
      1.926692,
      NULL,
      2,
      1.286203,
      0.916347,
      0,
      0,
      0.452341,
      1.592801,
      1.742076,
      1,
      1,
      NULL,
      0,
      NULL,
      1.933605,
      1,
      0.286840,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-28-1977',
      74.291370,
      1,
      7.758915,
      6.316793,
      0,
      NULL,
      ' 0-27-1975',
      0,
      3.277678,
      92.998318,
      0,
      NULL,
      1,
      1,
      0,
      74,
      0.762539,
      1.033864,
      177,
      '10-26-1993',
      145,
      117.862804,
      NULL,
      70,
      57,
      54,
      48,
      106,
      102.851645,
      79,
      54.830649,
      62,
      ' 4- 3-1978',
      7.987510,
      NULL,
      1,
      NULL,
      45,
      NULL,
      10.619068,
      ' 5- 1-1978',
      4,
      21,
      ' 0-14-1998',
      9,
      NULL,
      15,
      14,
      8.836746,
      2,
      0,
      NULL,
      0.195843,
      92,
      NULL,
      3.831835,
      NULL,
      13.049517,
      0.062872,
      1.897935,
      NULL,
      0.285057,
      ' 0-15-1992',
      2,
      2,
      3.788954,
      ' 0- 4-1998',
      70,
      1.411802,
      ' 5-29-1993',
      NULL,
      NULL,
      NULL,
      29,
      ' 1-11-1995',
      11,
      '11-27-1980',
      2,
      7,
      ' 3-25-1983',
      2.090942,
      92,
      ' 4-14-1978',
      NULL,
      1.773455,
      NULL,
      15.432665,
      2.738343,
      '10-11-1986',
      1,
      NULL,
      16.813434,
      ' 1-19-1998',
      48,
      46.620468,
      42,
      ' 4- 7-1994',
      1,
      69.396538,
      NULL,
      9,
      16,
      NULL,
      5,
      ' 5-22-1982',
      14.473371,
      1,
      73.872260,
      '10-22-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.611730);
commit;
end;
/


