set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8736368';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3240',
      '11343320',
      '33320030',
      '34124102',
      NULL,
      '42131220',
      '24243234',
      '30433003',
      NULL,
      '11334121',
      '32314030',
      '24103130',
      NULL,
      '34330430',
      '31231143',
      NULL,
      '41011422',
      '02030322',
      '22302230',
      '21034020',
      NULL,
      '24234240',
      '04322332',
      '32013311',
      '22303403',
      '13441432',
      '40401430',
      '04420030',
      '31301231',
      '13123210',
      '43202321',
      NULL,
      NULL,
      NULL,
      NULL,
      '12312421',
      '23120403',
      '31401332',
      '40031104',
      '32413333',
      NULL,
      '00124414',
      '42412133',
      '04201323',
      '01032014',
      '221',
      NULL,
      NULL,
      NULL,
      '1040402',
      2.738847,
      31.152940,
      NULL,
      NULL,
      '300130',
      2,
      ' 2- 8-1975',
      ' 8-16-1980',
      NULL,
      NULL,
      30,
      19.311299,
      NULL,
      NULL,
      44.809097,
      NULL,
      6,
      1.435145,
      42.808253,
      10,
      NULL,
      25.988220,
      27.437432,
      10.599746,
      3.052575,
      0,
      81.817886,
      21.669603,
      15,
      25.735216,
      45,
      6.624718,
      0,
      143,
      95.540979,
      NULL,
      NULL,
      1,
      95.787330,
      ' 6- 3-1991',
      1.020329,
      34.011816,
      16.127996,
      18,
      NULL,
      NULL,
      ' 5- 5-1990',
      1.703014,
      1.171110,
      0,
      1,
      0.402203,
      2.703948,
      NULL,
      0.263314,
      0.112629,
      0.692785,
      6,
      0.377711,
      1,
      3,
      1.650324,
      NULL,
      NULL,
      1,
      1.656424,
      0.475201,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      95,
      13,
      2.315073,
      0.263815,
      2,
      9.885299,
      '11-25-1985',
      3,
      0.205180,
      107.509113,
      1.643070,
      0,
      16,
      NULL,
      NULL,
      6.996623,
      NULL,
      NULL,
      NULL,
      ' 6-25-1998',
      42.094017,
      59.006022,
      35,
      105.045334,
      57.711454,
      101,
      56.199687,
      27,
      1.392120,
      62,
      69,
      85.169866,
      ' 0-21-1977',
      7,
      34,
      24.970843,
      75.712126,
      NULL,
      3,
      1.302691,
      NULL,
      21,
      6,
      '11-17-1979',
      1,
      NULL,
      25.359312,
      8,
      NULL,
      6,
      1.323793,
      21.017342,
      NULL,
      38,
      0.563480,
      NULL,
      13,
      31.906430,
      0,
      1,
      1.650104,
      0.951128,
      ' 4- 3-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      129.784392,
      4.319678,
      ' 3- 0-1989',
      NULL,
      NULL,
      NULL,
      7.412010,
      ' 0- 5-1996',
      25.861224,
      NULL,
      5,
      16,
      NULL,
      143.941487,
      17,
      ' 5-19-1999',
      1,
      3.421329,
      ' 8-28-1982',
      NULL,
      NULL,
      NULL,
      3,
      0,
      2,
      ' 1-21-1975',
      48,
      16,
      9,
      NULL,
      9.916101,
      56,
      ' 2- 2-2002',
      2.240111,
      42.148505,
      14,
      NULL,
      NULL,
      7.720474,
      NULL,
      55,
      '11-27-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


