set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8736368';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '32412403',
      '44044434',
      NULL,
      '24141311',
      '32214303',
      '42321201',
      '03041134',
      '04121202',
      NULL,
      '33001032',
      '20203342',
      '24144122',
      '31334042',
      '24112003',
      '23100244',
      '04234020',
      '04034324',
      '42424102',
      '41041423',
      '02140244',
      '10441020',
      '11042240',
      '40243114',
      '43021443',
      '03102021',
      '43030420',
      '44433430',
      '02322430',
      NULL,
      '34330022',
      '01102024',
      '01331104',
      NULL,
      '23211120',
      '40101042',
      NULL,
      '30212403',
      '41321200',
      NULL,
      '10334112',
      '42043340',
      NULL,
      '21314034',
      NULL,
      '101',
      '01',
      34,
      3,
      '4341434',
      NULL,
      44,
      2,
      NULL,
      '323230',
      4.079100,
      ' 5-21-1979',
      ' 9-20-1990',
      51.511359,
      90.840380,
      38,
      13,
      5.220579,
      26,
      NULL,
      5.260104,
      8,
      27,
      40.662936,
      27.617593,
      15.252625,
      26.715827,
      12.853726,
      9.238934,
      15.252891,
      2.157938,
      19.045208,
      7.784022,
      61,
      24,
      117,
      26,
      0,
      101.890331,
      NULL,
      6,
      23,
      203.723738,
      225.781744,
      ' 0-18-1984',
      69,
      41,
      10,
      25.357175,
      211.114320,
      83,
      ' 2-10-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      48,
      5,
      4,
      14.230091,
      1.144434,
      0,
      ' 7-27-1981',
      NULL,
      NULL,
      37.655279,
      1,
      0,
      129.771237,
      1,
      NULL,
      57,
      NULL,
      NULL,
      NULL,
      NULL,
      47,
      52.077321,
      95,
      66,
      3,
      28.135187,
      57,
      51.753312,
      45,
      73.513061,
      26,
      NULL,
      NULL,
      10,
      17.681337,
      NULL,
      74.440822,
      80,
      38.637324,
      NULL,
      NULL,
      1,
      16.010393,
      ' 1-12-1981',
      2.516248,
      NULL,
      19.171954,
      8,
      16.168269,
      NULL,
      0.444762,
      18,
      NULL,
      107.723657,
      0.542035,
      NULL,
      1,
      NULL,
      0.606203,
      0,
      1.131217,
      3.822637,
      ' 1-27-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      60,
      7.721895,
      '11-23-1991',
      NULL,
      NULL,
      NULL,
      4.342852,
      ' 2- 5-1988',
      21.918585,
      '10-15-2002',
      10.114154,
      4,
      NULL,
      57,
      93,
      ' 2-10-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      10.396289,
      NULL,
      73.287763,
      15,
      36,
      ' 8- 6-1992',
      NULL,
      2,
      ' 3-16-1989',
      NULL,
      NULL,
      NULL,
      14.391738,
      NULL,
      33.947982,
      1,
      NULL,
      '10-12-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


