set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9318626';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2242',
      '00400423',
      NULL,
      NULL,
      '44334403',
      '10310332',
      '14343134',
      '43144101',
      '01003142',
      '10121213',
      '04433144',
      NULL,
      '02342300',
      NULL,
      NULL,
      '01140142',
      '20143442',
      '32343111',
      '02010012',
      '33443240',
      '02331304',
      '40130144',
      NULL,
      NULL,
      '41143221',
      '41142342',
      '41112041',
      '21210341',
      NULL,
      '21104414',
      '30402314',
      '21432210',
      NULL,
      '20333334',
      '33441134',
      '44234022',
      '33343303',
      '02343143',
      NULL,
      '13430432',
      '11032424',
      '04414242',
      NULL,
      '10223321',
      '02444404',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      '322201',
      3.426020,
      ' 6-28-1992',
      ' 8-24-2003',
      81.623083,
      NULL,
      30.222488,
      11.831399,
      NULL,
      NULL,
      8.438402,
      NULL,
      18,
      18.932451,
      NULL,
      0,
      33,
      16.602696,
      17.553591,
      5,
      0.373383,
      11,
      NULL,
      0.798216,
      15.466031,
      1.285306,
      20.053134,
      6.998384,
      0,
      43.499502,
      133,
      31.440545,
      42,
      49,
      136.442821,
      ' 7- 9-2003',
      34,
      19.523473,
      NULL,
      9.814633,
      136,
      47,
      ' 0- 4-1975',
      NULL,
      7,
      10,
      3.351531,
      3,
      0.845508,
      0.172685,
      3,
      2,
      0.285533,
      3,
      1,
      0,
      0,
      1.189644,
      0,
      1.205426,
      1,
      NULL,
      3.195842,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      89,
      16.094186,
      10.606666,
      6.276666,
      NULL,
      NULL,
      ' 6-28-2003',
      0.787441,
      1.455493,
      82.311944,
      1,
      0.041363,
      10,
      0.869463,
      6.546954,
      5,
      NULL,
      NULL,
      NULL,
      ' 3- 1-1980',
      18,
      12,
      80,
      12.965116,
      42,
      16,
      46.397474,
      34.330646,
      31.428956,
      9.924326,
      NULL,
      38.940320,
      ' 6- 2-1983',
      15,
      13,
      NULL,
      9.997218,
      NULL,
      7,
      5,
      ' 3-19-1979',
      19,
      17.477558,
      ' 7-12-1991',
      0.844419,
      11,
      13,
      20.464976,
      20.854367,
      11,
      1.517229,
      8.399981,
      1.171778,
      94,
      1.696703,
      2,
      0.845594,
      11,
      0,
      0,
      NULL,
      NULL,
      ' 6-12-1988',
      9.865030,
      1,
      4.064997,
      ' 5-10-1986',
      NULL,
      1,
      ' 0- 9-1978',
      NULL,
      NULL,
      NULL,
      22.968239,
      '11-15-1979',
      9.962158,
      NULL,
      7,
      9.401388,
      '10-12-1981',
      NULL,
      4.189190,
      NULL,
      NULL,
      1.419075,
      '11- 7-2000',
      NULL,
      11.877200,
      NULL,
      NULL,
      3,
      3,
      ' 4-12-1999',
      18,
      26,
      46,
      ' 1- 3-1986',
      1,
      14.252881,
      ' 9-19-1989',
      10,
      59.997922,
      14,
      8,
      ' 3-24-1994',
      52,
      0.448941,
      20,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12);
commit;
end;
/


