set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9215424';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0112',
      '01401203',
      '12232244',
      NULL,
      '42342332',
      '13202004',
      NULL,
      NULL,
      '30314101',
      NULL,
      '21331220',
      NULL,
      '02110301',
      '00020423',
      NULL,
      '22001244',
      '31300333',
      '20201433',
      '10431142',
      NULL,
      '34003431',
      '01211122',
      '42020444',
      '21131313',
      NULL,
      '00402312',
      '12232433',
      '01343444',
      NULL,
      '43112014',
      '21144322',
      NULL,
      '13413410',
      '31114002',
      '41202122',
      '34423140',
      '13032044',
      '30421110',
      '11011140',
      '22241344',
      '12301312',
      '22304112',
      '04231142',
      '13001114',
      '04000411',
      '003',
      '42',
      NULL,
      NULL,
      '2334100',
      3,
      NULL,
      2,
      NULL,
      NULL,
      5,
      ' 0-12-1989',
      NULL,
      44,
      NULL,
      19.007170,
      NULL,
      22,
      5.923458,
      55,
      13,
      NULL,
      4.242066,
      18.684778,
      1.816603,
      24.869219,
      16,
      9.179812,
      3,
      17,
      21,
      23,
      NULL,
      8,
      1,
      NULL,
      13,
      NULL,
      NULL,
      25.285541,
      NULL,
      172.091074,
      198,
      89.897860,
      ' 1-22-1995',
      35.581873,
      NULL,
      7.317236,
      7,
      112,
      126,
      ' 4- 1-1978',
      0,
      1,
      NULL,
      0,
      1.391041,
      1,
      NULL,
      1,
      1.117267,
      1.989465,
      0.808980,
      1,
      1,
      0.783896,
      1,
      NULL,
      1.586240,
      1,
      1.151675,
      0.141191,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-16-1999',
      45,
      10.871602,
      NULL,
      13,
      NULL,
      8,
      ' 7-27-1995',
      NULL,
      1,
      37.591308,
      0,
      NULL,
      67,
      0,
      1.632747,
      28,
      1.672507,
      NULL,
      58,
      ' 2- 2-1981',
      78.856746,
      32,
      76,
      101,
      110,
      NULL,
      45,
      NULL,
      19.007692,
      NULL,
      29,
      NULL,
      '11- 1-1998',
      3.458070,
      19,
      NULL,
      11,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.618214,
      5.796268,
      1.283941,
      ' 3-25-1998',
      204.311613,
      15.253669,
      ' 5- 2-1986',
      34.891873,
      2,
      NULL,
      19,
      ' 9-11-1974',
      NULL,
      NULL,
      5,
      3,
      ' 5-24-1979',
      NULL,
      74,
      NULL,
      NULL,
      NULL,
      ' 3-20-1988',
      NULL,
      2.526824,
      NULL,
      3,
      2,
      3,
      ' 9-12-1983',
      15.932724,
      38,
      0.018148,
      ' 0-14-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.834966);
commit;
end;
/


