set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9002745';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2312',
      NULL,
      '34421411',
      '01203233',
      '42031401',
      '40044442',
      '00244031',
      '33331232',
      '44413244',
      NULL,
      '00033342',
      '00324424',
      '33104310',
      NULL,
      '33014214',
      '14042231',
      '44231301',
      '40402323',
      '00320333',
      '33312242',
      '43120310',
      '20231010',
      NULL,
      NULL,
      '30344212',
      '33231333',
      '11042414',
      '02144010',
      '33034224',
      '00203122',
      '43123330',
      NULL,
      '04120240',
      '40104432',
      NULL,
      '00330342',
      '24304401',
      NULL,
      NULL,
      '43241144',
      NULL,
      NULL,
      '02031141',
      '00240301',
      '13042404',
      '',
      '',
      NULL,
      NULL,
      '0030011',
      1,
      1.283524,
      0,
      NULL,
      '040414',
      NULL,
      ' 3- 6-2000',
      NULL,
      40.164065,
      NULL,
      49,
      15.763477,
      17,
      NULL,
      78.929010,
      18,
      26,
      14.999453,
      27,
      12,
      11.254522,
      NULL,
      22,
      16,
      3,
      NULL,
      17.446053,
      1.472365,
      19,
      0,
      0,
      23.808345,
      NULL,
      155.656639,
      218,
      55.669532,
      30,
      91.919539,
      166.742416,
      NULL,
      10.345994,
      20,
      NULL,
      33,
      11,
      65.777005,
      ' 8- 2-1982',
      0,
      1.071870,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.515002,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14,
      NULL,
      39.902071,
      75,
      28.847240,
      52,
      8,
      '11- 8-1976',
      32,
      8.539237,
      ' 0-13-1982',
      NULL,
      26.903119,
      21.204717,
      27,
      15.592647,
      3.121777,
      NULL,
      5.485840,
      NULL,
      NULL,
      1,
      0.933105,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-26-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      63.164229,
      14,
      42.977027,
      ' 4-10-2003',
      0,
      15,
      '11- 2-2003',
      NULL,
      8.818082,
      22,
      NULL,
      ' 8-28-1977',
      NULL,
      1.881006,
      12,
      ' 2-26-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      1.630468,
      NULL,
      NULL,
      NULL,
      14,
      3.411993,
      3,
      0.269483,
      5.893369,
      NULL,
      NULL,
      NULL,
      0,
      68,
      NULL,
      1,
      63,
      NULL,
      1,
      84,
      0.985963,
      1.157019,
      57,
      NULL,
      7,
      NULL,
      0.813100,
      NULL,
      1.001934,
      2.982424,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.329615,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.830191,
      NULL,
      NULL,
      2.793381,
      NULL,
      4,
      2,
      11.324967,
      NULL,
      NULL,
      NULL,
      NULL,
      19.659309,
      NULL,
      NULL,
      3.288910,
      0.288652,
      0,
      0.481284,
      0.612042,
      NULL,
      ' 6- 5-1989',
      NULL,
      ' 6-15-1993',
      NULL,
      '10- 0-1977',
      NULL,
      ' 1- 7-1981',
      NULL);
commit;
end;
/


