set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9885315';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '0',
      NULL,
      NULL,
      NULL,
      '1',
      '4',
      '4',
      '2',
      '3',
      NULL,
      '3',
      '4',
      '1',
      NULL,
      NULL,
      '3',
      '1',
      '1',
      NULL,
      '2',
      '3',
      '4',
      NULL,
      '',
      NULL,
      '',
      '4',
      '3',
      '2',
      NULL,
      NULL,
      '',
      '',
      '3',
      '2',
      '1',
      '1',
      '1',
      '4',
      '1',
      NULL,
      '4',
      '3',
      '3',
      '331',
      '23144122',
      14.868145,
      23.057310,
      '0030330',
      2,
      0,
      0,
      0,
      '423332',
      4,
      '10-14-2001',
      ' 9- 4-1999',
      16,
      166.189094,
      NULL,
      7,
      NULL,
      1,
      21.575450,
      10.903640,
      NULL,
      2,
      17,
      11.478997,
      3,
      NULL,
      NULL,
      2.395676,
      1,
      NULL,
      NULL,
      2.204429,
      28.683706,
      0,
      5,
      0.638183,
      NULL,
      NULL,
      117,
      10,
      0.992855,
      33,
      59,
      ' 2-11-1980',
      NULL,
      NULL,
      8,
      17.037756,
      NULL,
      35,
      ' 1-27-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      68,
      0,
      1,
      30,
      2,
      2.696414,
      12.241970,
      NULL,
      NULL,
      NULL,
      NULL,
      13.505773,
      58.922971,
      7.731897,
      66.201562,
      35.110185,
      14.893348,
      45,
      39.798859,
      NULL,
      30.441231,
      35.912862,
      18,
      ' 7- 8-1976',
      7.129517,
      2,
      0,
      10.454752,
      7,
      0,
      3.486648,
      ' 9- 6-2000',
      0.693816,
      NULL,
      ' 1-27-2003',
      NULL,
      1.563300,
      5,
      NULL,
      7.969664,
      NULL,
      1,
      NULL,
      0.479608,
      NULL,
      0,
      1,
      4.128783,
      3.052407,
      14.689346,
      3,
      1.269402,
      1,
      ' 0-10-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      26.198320,
      '11-13-1982',
      25,
      ' 5-10-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      11,
      '11- 5-1982',
      20.141798,
      8,
      4.449053,
      NULL,
      NULL,
      31.945346,
      ' 5-25-1987',
      0.710254,
      12.180036,
      5,
      NULL,
      ' 3- 3-2000',
      45.180392,
      0.412989,
      NULL,
      ' 4- 1-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


