set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9885315';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      '4',
      '2',
      '3',
      '2',
      '3',
      NULL,
      '4',
      '4',
      '1',
      '3',
      NULL,
      '4',
      NULL,
      '1',
      '2',
      '4',
      '1',
      '3',
      NULL,
      '4',
      '4',
      '2',
      '',
      '0',
      '',
      '1',
      '4',
      '2',
      NULL,
      '0',
      '',
      NULL,
      '4',
      '1',
      '3',
      NULL,
      '2',
      '4',
      NULL,
      '2',
      '4',
      '4',
      '3',
      '322',
      '21433333',
      77.492143,
      41,
      NULL,
      1.516732,
      31.679487,
      2,
      1,
      '421223',
      6,
      ' 3-13-1986',
      ' 2- 2-1979',
      71.962897,
      30,
      17,
      11.774158,
      26.848739,
      10,
      19.643894,
      NULL,
      3.290268,
      8.868040,
      12.945980,
      NULL,
      NULL,
      NULL,
      6,
      3,
      NULL,
      NULL,
      18.549293,
      NULL,
      38,
      13.368396,
      56,
      NULL,
      1,
      NULL,
      143.164391,
      30.925711,
      NULL,
      85,
      NULL,
      '10- 3-1981',
      31,
      6,
      NULL,
      12,
      NULL,
      NULL,
      ' 4-15-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      47,
      13,
      NULL,
      13.376469,
      NULL,
      NULL,
      ' 6-22-1978',
      1.937081,
      1.760045,
      73,
      NULL,
      1,
      4,
      0,
      4.418709,
      37,
      NULL,
      NULL,
      NULL,
      ' 3-17-1998',
      82,
      NULL,
      16,
      22.108967,
      95,
      NULL,
      43,
      67.779287,
      33.840374,
      21,
      NULL,
      6.435339,
      ' 5- 2-1986',
      14.849229,
      2,
      0,
      23.716283,
      50.787144,
      25.050244,
      NULL,
      ' 9-23-1983',
      15,
      9,
      ' 8-26-1998',
      4.761483,
      10.588278,
      6,
      2.924385,
      4,
      NULL,
      0.817503,
      1.829690,
      1.138941,
      0.879044,
      NULL,
      0.614677,
      0.163829,
      2.797774,
      NULL,
      0.303798,
      1,
      1.664031,
      ' 1- 8-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      76,
      27.519481,
      '10-20-1992',
      NULL,
      NULL,
      NULL,
      25.600860,
      ' 6- 2-1981',
      2.008558,
      NULL,
      0,
      7,
      ' 3-20-1982',
      32,
      42,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      ' 9-23-1991',
      2.165340,
      20.405602,
      8.299901,
      ' 8-10-1974',
      2.606381,
      NULL,
      ' 3-14-2001',
      NULL,
      7.980814,
      14.664691,
      46.303610,
      ' 3- 0-1998',
      60.578901,
      1.464719,
      74.200201,
      ' 9-22-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


