set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9311269';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4431',
      '33133330',
      '34030213',
      '44412324',
      NULL,
      '31342212',
      '42022200',
      '42142321',
      '12122011',
      NULL,
      NULL,
      '44121320',
      '30343211',
      '44401100',
      NULL,
      '12341212',
      '44210114',
      '33320221',
      '31333032',
      '20204023',
      '02144202',
      NULL,
      NULL,
      '21112124',
      '22113043',
      '32324033',
      '13440112',
      '44042013',
      '24203121',
      '02441112',
      '13120241',
      NULL,
      '34001112',
      '12143422',
      '20411321',
      '22210310',
      '14011303',
      '32103240',
      '41002042',
      '20124233',
      '00410033',
      '33011011',
      '12301240',
      '21424033',
      NULL,
      NULL,
      '00',
      NULL,
      NULL,
      '2040014',
      2,
      0,
      0,
      NULL,
      NULL,
      4.371282,
      '10-15-1996',
      '11- 1-1998',
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      21,
      3,
      5,
      8,
      10.084432,
      14,
      NULL,
      10.156835,
      NULL,
      15,
      31.556194,
      9,
      34.721764,
      6.700539,
      50.654540,
      26.020694,
      1,
      72,
      NULL,
      88,
      82.284306,
      NULL,
      20.644035,
      '10- 5-1991',
      NULL,
      76,
      NULL,
      28,
      65.734102,
      170.528509,
      ' 3-20-1979',
      3,
      3,
      0,
      0,
      0.786287,
      0,
      1.060209,
      0,
      0.834424,
      1.291552,
      0,
      1,
      1,
      1.641839,
      1.516566,
      NULL,
      NULL,
      1,
      NULL,
      1.143363,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 6-1998',
      41,
      0.516954,
      4.096239,
      11,
      5.605358,
      1,
      ' 3- 7-1988',
      NULL,
      0.499339,
      39.744284,
      1,
      NULL,
      NULL,
      NULL,
      2,
      78.378732,
      NULL,
      NULL,
      76,
      ' 1-29-1985',
      54.614169,
      1.527178,
      NULL,
      76.538119,
      5,
      71.216286,
      70,
      79.781303,
      25.262188,
      NULL,
      78.700943,
      53,
      '11- 3-2000',
      14.429025,
      16,
      NULL,
      2,
      1,
      45.559662,
      1.513670,
      '10-18-1998',
      NULL,
      9.109404,
      ' 1-14-1991',
      2,
      2.261604,
      5,
      6,
      NULL,
      12.086668,
      0,
      2.892316,
      1.816205,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.971959,
      0.583559,
      0,
      0,
      NULL,
      0.979331,
      0.470301,
      1,
      ' 8-20-1990',
      238,
      3.902673,
      ' 9- 9-1979',
      NULL,
      NULL,
      NULL,
      37,
      ' 2-23-1981',
      21.168972,
      ' 3- 7-1980',
      9,
      2,
      '10- 6-1979',
      76,
      6,
      ' 0-25-1986',
      5.003246,
      0.611680,
      NULL,
      5,
      0,
      ' 1-11-1998',
      2,
      NULL,
      0,
      ' 4-19-1991',
      NULL,
      28,
      15.373298,
      '10-26-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


