set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9410455';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3304',
      NULL,
      '23203143',
      '13440102',
      '23124321',
      NULL,
      '00034330',
      '00424032',
      '00012442',
      NULL,
      '20310033',
      '12042120',
      '02024022',
      '23214212',
      '30432111',
      '40431421',
      '11042104',
      '43023442',
      '40041011',
      '11423112',
      '32023223',
      '04130133',
      NULL,
      NULL,
      '14313310',
      '40104241',
      NULL,
      '20402323',
      NULL,
      '32303411',
      '23234041',
      '14303344',
      '22031002',
      '00024240',
      NULL,
      '22023241',
      NULL,
      NULL,
      '42234314',
      '03432203',
      '01334103',
      '40031204',
      '11244414',
      '33242221',
      '01400431',
      '020',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.588552,
      3,
      NULL,
      '032133',
      NULL,
      ' 9-29-1998',
      NULL,
      75.375843,
      NULL,
      13.663720,
      8.708309,
      13.831091,
      2,
      41.101905,
      1.849198,
      NULL,
      NULL,
      18,
      11,
      NULL,
      4,
      1.364216,
      9,
      1.586269,
      1.786681,
      NULL,
      3,
      2.065574,
      4,
      14.161948,
      12.052966,
      1,
      54,
      NULL,
      29,
      148,
      10,
      67,
      ' 4- 7-1994',
      13.589571,
      19.319335,
      12.469820,
      17.055317,
      27.408255,
      21,
      ' 4-26-2000',
      1,
      2,
      0,
      1,
      0,
      0,
      NULL,
      3,
      1.192199,
      1,
      NULL,
      1.440657,
      1.533423,
      0.218579,
      1,
      0,
      0.732172,
      1.130783,
      1,
      1.135032,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2- 0-1988',
      NULL,
      NULL,
      12,
      2,
      30,
      NULL,
      ' 5-29-1986',
      0.670267,
      NULL,
      196,
      1.387011,
      NULL,
      59.748238,
      0,
      NULL,
      74.784748,
      NULL,
      NULL,
      NULL,
      ' 6- 1-1998',
      96.358366,
      40,
      NULL,
      73,
      44.461588,
      39,
      101.233199,
      17.319984,
      93,
      42,
      14,
      18,
      '11-13-1980',
      24,
      3,
      5.350742,
      19.755028,
      39,
      64.240020,
      6.950728,
      ' 7-20-1988',
      NULL,
      7.816267,
      ' 2- 0-1986',
      7,
      2.260970,
      13,
      0.189072,
      15.813349,
      5,
      NULL,
      6.706168,
      1,
      9.254066,
      0,
      2,
      8,
      8,
      NULL,
      NULL,
      2.317716,
      0,
      ' 5- 3-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.827940,
      ' 5-23-2002',
      NULL,
      NULL,
      NULL,
      29,
      ' 4-12-1975',
      34,
      ' 5-12-1990',
      7,
      10.951384,
      ' 8-22-1986',
      10.397421,
      85,
      NULL,
      NULL,
      5.692593,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      18.167484,
      NULL,
      25,
      16.753621,
      NULL,
      '10-23-1994',
      0,
      47,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


