set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9649906';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4322',
      '04332444',
      '10244031',
      '01042103',
      '00431202',
      '01433340',
      '40140321',
      '13000330',
      NULL,
      '14210113',
      '11433243',
      '23433214',
      '32311122',
      '21402144',
      '34114233',
      '43021124',
      '34142100',
      '30003120',
      NULL,
      NULL,
      '22232423',
      '21223001',
      '44331200',
      NULL,
      '40420220',
      '22100044',
      '12021434',
      '10041412',
      '30112130',
      '20244444',
      '31211032',
      '40342100',
      '00221233',
      '31402131',
      '14330043',
      '30134040',
      NULL,
      '40222034',
      '02403144',
      '40014213',
      '31314102',
      '03243331',
      NULL,
      '10234132',
      NULL,
      '332',
      '21',
      1,
      NULL,
      NULL,
      3.386088,
      1,
      2,
      NULL,
      '231430',
      1.684179,
      ' 0-24-1990',
      ' 8-13-1997',
      66,
      85,
      0.168167,
      4.441649,
      2.647364,
      NULL,
      13,
      7,
      0,
      6.920697,
      6,
      9,
      8.570727,
      1.443856,
      14.863202,
      13,
      5,
      7,
      36.904976,
      7.640511,
      46,
      5,
      12.139058,
      9.885189,
      1.995871,
      35.797562,
      39,
      35,
      157,
      14,
      138,
      NULL,
      22.073642,
      8,
      4.008235,
      0.071474,
      80,
      44,
      ' 3- 3-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      59.621050,
      NULL,
      5,
      44.429771,
      3.351250,
      ' 2-17-1988',
      1.154385,
      0,
      111,
      3,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-14-2001',
      NULL,
      16,
      51.041502,
      77.579113,
      72,
      56,
      82.352329,
      NULL,
      NULL,
      NULL,
      18,
      60,
      ' 9-29-1988',
      2,
      2,
      NULL,
      21,
      35,
      NULL,
      5,
      ' 6-14-1976',
      1.868426,
      6.429088,
      ' 3- 9-1994',
      NULL,
      10.212492,
      5,
      11.194872,
      1,
      0.505126,
      1,
      5,
      NULL,
      25.299696,
      NULL,
      3,
      0,
      21.453831,
      10,
      8,
      5.731763,
      2,
      ' 2- 6-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25,
      ' 1-18-1999',
      NULL,
      NULL,
      NULL,
      20.391152,
      ' 0- 3-1997',
      28,
      ' 7-26-1976',
      13.593722,
      8,
      ' 3- 6-1996',
      53.773673,
      33.516472,
      '11- 5-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      12,
      NULL,
      NULL,
      45.571952,
      2.648681,
      '11-20-1976',
      1,
      30.106109,
      NULL,
      NULL,
      32,
      6,
      NULL,
      NULL,
      19,
      0.558200,
      236.800379,
      '10- 3-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


