set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9649906';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '0',
      '0',
      '3',
      '3',
      NULL,
      '1',
      NULL,
      '2',
      NULL,
      '1',
      '3',
      '0',
      '4',
      '3',
      '1',
      NULL,
      '1',
      '3',
      '3',
      '4',
      '4',
      '4',
      '3',
      '',
      '3',
      '',
      '2',
      '3',
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      '1',
      '4',
      NULL,
      NULL,
      '4',
      '1',
      '0',
      '4',
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      9,
      18,
      '4210232',
      3.803350,
      5.626897,
      0,
      NULL,
      '400033',
      2,
      NULL,
      ' 5-26-1995',
      128,
      184.311022,
      NULL,
      7.808132,
      16,
      NULL,
      4,
      5,
      9,
      10,
      10,
      5,
      5,
      4.773200,
      14,
      12.388521,
      4.866340,
      1,
      NULL,
      12,
      30.583483,
      9,
      32,
      5,
      NULL,
      44,
      NULL,
      67.479792,
      24.679328,
      128.701704,
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      1.116770,
      NULL,
      28,
      ' 4- 6-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16.910330,
      36,
      NULL,
      17,
      8,
      3,
      NULL,
      1,
      NULL,
      40,
      0,
      NULL,
      15,
      3.644925,
      2.952766,
      31.474300,
      NULL,
      NULL,
      NULL,
      NULL,
      79,
      NULL,
      75.019094,
      62,
      NULL,
      NULL,
      NULL,
      95,
      75,
      46,
      NULL,
      21,
      ' 1- 9-1974',
      14,
      NULL,
      NULL,
      31.680872,
      NULL,
      2,
      6.856725,
      ' 0-15-1979',
      14.148992,
      15.333554,
      ' 9-25-1982',
      0.366745,
      8.993771,
      0,
      6,
      NULL,
      NULL,
      4,
      NULL,
      1.400970,
      2.990332,
      1.272277,
      0.807979,
      2,
      12,
      NULL,
      1.887703,
      0,
      0,
      ' 0-23-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.593551,
      ' 4-29-1997',
      NULL,
      NULL,
      NULL,
      3.224693,
      ' 4- 2-1994',
      NULL,
      ' 2-25-1979',
      9,
      1,
      '10-19-1995',
      67.404759,
      25,
      ' 3- 3-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      14.984736,
      NULL,
      NULL,
      NULL,
      24,
      ' 7-20-1997',
      NULL,
      333,
      '10-27-1986',
      NULL,
      1,
      6,
      85.832423,
      '11-27-1998',
      57,
      1,
      157,
      ' 7-14-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


