set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8132060';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '34434343',
      '14224303',
      '24331312',
      '20334342',
      '42014113',
      '43034422',
      '41211120',
      '30023322',
      '44441322',
      NULL,
      '40401433',
      '41040444',
      '31031340',
      '22122401',
      '30014342',
      '21222021',
      '12421443',
      '43342231',
      '40211322',
      '20230443',
      '31313110',
      '31212422',
      NULL,
      '31141033',
      '00424223',
      '44133130',
      NULL,
      NULL,
      '14442042',
      NULL,
      '02400304',
      '32203221',
      '41043214',
      '30304004',
      NULL,
      '10314224',
      '43112113',
      '14314103',
      '11312140',
      NULL,
      '01200444',
      '00300342',
      '20422004',
      '01221240',
      '422',
      '40',
      NULL,
      NULL,
      '3224330',
      0,
      0.507780,
      1,
      NULL,
      '203301',
      4.224964,
      ' 2-14-1986',
      ' 0- 3-1980',
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      78,
      13,
      12.317148,
      16,
      4,
      8.778858,
      0.631145,
      2.577510,
      NULL,
      10,
      20.636989,
      16,
      51,
      10.434362,
      34,
      6,
      90.693557,
      14.367628,
      NULL,
      96.965150,
      26,
      55,
      39.051447,
      0.767751,
      8.140537,
      '11- 3-1992',
      44,
      4.743318,
      11,
      19.739853,
      139,
      NULL,
      '10-21-1981',
      3,
      NULL,
      0.969546,
      1.938721,
      1,
      0,
      NULL,
      2.280768,
      1,
      1,
      NULL,
      1.932722,
      1.698139,
      0.251599,
      1,
      1.486803,
      0.610212,
      0.739328,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      69,
      NULL,
      3.942955,
      11.912590,
      2.296322,
      3,
      ' 4-22-1995',
      0.419661,
      0.223221,
      NULL,
      0.361218,
      0,
      174,
      1,
      0.340747,
      69.581823,
      1.292700,
      1,
      78,
      '11-15-2001',
      62,
      85,
      NULL,
      62.773767,
      14,
      72,
      NULL,
      66.537250,
      39,
      37,
      76,
      60,
      ' 1- 8-1977',
      6.351007,
      NULL,
      22.403614,
      NULL,
      NULL,
      136,
      NULL,
      '10-16-1981',
      9,
      12,
      ' 5-15-1975',
      3.625557,
      20.523599,
      4.372977,
      12.622773,
      5.299005,
      7,
      0.873621,
      NULL,
      0.152291,
      NULL,
      2.359276,
      0.866885,
      13,
      6,
      0.585878,
      NULL,
      1,
      1,
      ' 9-27-1991',
      4,
      NULL,
      1,
      ' 0-23-1982',
      10.681081,
      NULL,
      ' 4- 2-1988',
      NULL,
      NULL,
      NULL,
      27.085644,
      ' 3-15-2002',
      45,
      ' 2-20-2003',
      3.169443,
      4.236018,
      NULL,
      36,
      49.217148,
      ' 9-29-1981',
      NULL,
      0,
      ' 4- 1-1990',
      1,
      5,
      '11- 9-1995',
      3,
      1,
      27.398795,
      '10-29-2001',
      27.703815,
      5,
      16.896987,
      ' 5- 9-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10);
commit;
end;
/


