set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9127379';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1433',
      '12204203',
      '13040210',
      NULL,
      '34321301',
      '20023010',
      '22123012',
      '03042120',
      '20441013',
      '41143403',
      '24112220',
      NULL,
      '22013201',
      '12024422',
      NULL,
      '30202124',
      '00224312',
      NULL,
      '43432120',
      '01231240',
      NULL,
      NULL,
      NULL,
      '03432324',
      '30021324',
      '01032121',
      NULL,
      '32113043',
      NULL,
      '40242401',
      '42343131',
      '34403404',
      '04100232',
      '04301010',
      '43412200',
      NULL,
      '41414241',
      '12423200',
      '21201233',
      '20142020',
      '13344204',
      NULL,
      '14114232',
      '42420140',
      '03003003',
      '041',
      '22',
      NULL,
      NULL,
      '3100020',
      NULL,
      0,
      2,
      NULL,
      '222301',
      NULL,
      ' 4-24-1998',
      '10-21-1986',
      NULL,
      NULL,
      17.510179,
      17.357421,
      NULL,
      13,
      29,
      22,
      4,
      11,
      16.619930,
      NULL,
      25.331304,
      15.237155,
      30.167170,
      20.975130,
      1,
      NULL,
      21.826098,
      NULL,
      16.815443,
      9.004863,
      81.158016,
      14.893528,
      0,
      50.058151,
      189,
      81.299963,
      80.997910,
      124.986984,
      42.459874,
      ' 1-16-1999',
      58,
      1,
      20,
      21,
      65.256338,
      184.706577,
      ' 9- 8-1983',
      1.669827,
      NULL,
      3.693934,
      0.340249,
      NULL,
      0.883555,
      5,
      1.656511,
      0,
      0,
      0,
      1,
      0.460266,
      3,
      0.273134,
      NULL,
      1.092518,
      0.694041,
      0.634436,
      2.759695,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-23-1979',
      70.840796,
      NULL,
      NULL,
      5,
      NULL,
      7.580792,
      ' 8-27-1987',
      1.232448,
      1.142121,
      45.177628,
      1.341319,
      3.634025,
      117,
      NULL,
      NULL,
      10.652950,
      NULL,
      NULL,
      NULL,
      ' 0-16-1987',
      48.315121,
      50,
      61.971482,
      54.268987,
      67.866212,
      60,
      57.696905,
      57,
      84,
      23,
      28,
      NULL,
      '10- 8-1976',
      2.495854,
      8,
      5,
      NULL,
      46.211547,
      NULL,
      9,
      NULL,
      0,
      NULL,
      NULL,
      10.259988,
      8,
      18.192134,
      10,
      27,
      10,
      1,
      18.049976,
      NULL,
      NULL,
      NULL,
      6,
      13.308344,
      9.946684,
      1.868154,
      NULL,
      0.021020,
      1.745855,
      '10-28-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      207,
      1,
      ' 9- 0-1998',
      NULL,
      NULL,
      NULL,
      15,
      ' 7- 0-1984',
      41,
      ' 2-26-1974',
      NULL,
      13,
      ' 6- 0-2002',
      57.516290,
      32,
      ' 6-29-2002',
      1.112129,
      11.573660,
      ' 6-25-1983',
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.927984,
      '10-26-1979',
      26,
      3,
      28.064094,
      ' 5-23-1991',
      0.058866,
      30.886176,
      ' 8-18-1998',
      7.240891,
      16,
      8,
      7.559624,
      ' 2- 9-2002',
      47,
      1,
      47,
      ' 1-23-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


