set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9127379';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0210',
      '00010123',
      '34421404',
      '21302104',
      '24140413',
      NULL,
      '44120240',
      '33432341',
      '14143043',
      '30423243',
      NULL,
      '01142023',
      '02101100',
      '23301301',
      NULL,
      '11302130',
      '31321201',
      NULL,
      '11143103',
      NULL,
      '01202330',
      NULL,
      '22332432',
      '00023002',
      '43130030',
      '13011440',
      NULL,
      '24233333',
      '40321023',
      '12003244',
      '31413012',
      '01434013',
      NULL,
      '32142234',
      '21034422',
      '24100123',
      '33144432',
      NULL,
      '01230440',
      NULL,
      '34433202',
      '03140040',
      '44031411',
      '12140233',
      '10202332',
      '243',
      '01',
      33,
      10.532827,
      '0120423',
      0.109732,
      29.613080,
      1,
      NULL,
      '232244',
      NULL,
      ' 9-15-2000',
      ' 2- 3-1997',
      111.420705,
      11.971069,
      14.719385,
      NULL,
      7.921287,
      21.487354,
      NULL,
      19,
      3.425413,
      15,
      NULL,
      NULL,
      42,
      20.323056,
      22,
      15.392254,
      21,
      14,
      41,
      17,
      35.757833,
      10,
      NULL,
      4.669373,
      0.499977,
      39,
      NULL,
      7,
      31,
      9,
      179,
      ' 6- 5-1988',
      NULL,
      NULL,
      10,
      10,
      51,
      93,
      ' 2- 8-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17,
      0.518399,
      NULL,
      3,
      5.630855,
      ' 0-26-1992',
      NULL,
      1,
      NULL,
      1,
      5.560849,
      98.146323,
      NULL,
      1.005200,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      23.809277,
      NULL,
      100.158038,
      73.108109,
      91,
      59.191346,
      21,
      25,
      NULL,
      78,
      0.385190,
      63.464991,
      ' 1-17-2001',
      33.508920,
      3.625362,
      1.397430,
      NULL,
      NULL,
      NULL,
      0.308762,
      NULL,
      NULL,
      21,
      ' 2-28-1977',
      0.391111,
      17.780954,
      7,
      9.836908,
      0,
      3.959003,
      0.517851,
      21,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.732758,
      1.008687,
      1.511430,
      0.464260,
      0.970170,
      ' 7- 1-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      79,
      7,
      ' 7- 8-1999',
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      34.245280,
      NULL,
      4,
      5,
      NULL,
      28,
      34.845172,
      ' 0-11-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      18.415497,
      ' 1-13-1989',
      44.159476,
      5,
      NULL,
      ' 2-17-2001',
      NULL,
      NULL,
      ' 2- 6-1998',
      11,
      13.371208,
      2,
      17.145988,
      ' 7-13-1980',
      28,
      1.542980,
      10.797010,
      '10-20-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


