set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9427015';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '2',
      '3',
      NULL,
      '0',
      '3',
      '2',
      '1',
      '2',
      NULL,
      '1',
      '4',
      '4',
      NULL,
      NULL,
      '4',
      '3',
      '3',
      '2',
      '1',
      '0',
      '4',
      NULL,
      '4',
      '',
      '3',
      '',
      '4',
      '2',
      '2',
      '3',
      '2',
      '',
      NULL,
      '1',
      NULL,
      '3',
      '2',
      '2',
      '0',
      '3',
      NULL,
      '2',
      '4',
      '1',
      '210',
      '13122231',
      53.367516,
      57,
      '1122220',
      0.041351,
      0,
      1,
      1,
      '332202',
      4.320998,
      ' 6-23-1981',
      ' 3-28-1990',
      40,
      247.627416,
      20,
      16,
      13,
      2.566572,
      22,
      5.032313,
      5,
      5.799792,
      5.750256,
      21,
      37,
      12.882320,
      NULL,
      NULL,
      11,
      12,
      11,
      NULL,
      9,
      1.543056,
      NULL,
      7.683576,
      0.903688,
      NULL,
      NULL,
      35.179691,
      66,
      170,
      9,
      NULL,
      19.267406,
      43.445822,
      NULL,
      31.584711,
      169,
      127.080291,
      ' 0-23-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3.547375,
      7,
      0.345936,
      ' 6-24-2003',
      1.903167,
      NULL,
      164,
      1,
      0,
      37.851646,
      1,
      2.125657,
      62,
      NULL,
      NULL,
      NULL,
      NULL,
      83.384735,
      65.437662,
      15.161742,
      39,
      67.937369,
      65.224224,
      21.808549,
      6,
      80,
      8,
      54.545481,
      NULL,
      ' 2- 8-2002',
      28,
      1,
      5.126889,
      51,
      NULL,
      NULL,
      NULL,
      ' 7-28-1988',
      2,
      11,
      '10- 0-1993',
      12,
      15.203371,
      NULL,
      17,
      17.449646,
      6.984238,
      NULL,
      15,
      1.005472,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.576073,
      1.244440,
      ' 7-25-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.056275,
      ' 5- 4-1986',
      NULL,
      NULL,
      NULL,
      15.264574,
      ' 7-19-1999',
      NULL,
      NULL,
      3.666994,
      11.139431,
      ' 0- 4-1997',
      92.514156,
      3.111218,
      ' 7-27-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      ' 4-19-2002',
      69,
      24,
      28,
      ' 5-16-2002',
      NULL,
      68,
      NULL,
      1.367384,
      17.971178,
      10.146175,
      NULL,
      ' 3- 3-1996',
      15.069367,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


