set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9427015';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      '4',
      '4',
      '0',
      '0',
      NULL,
      '4',
      '3',
      '4',
      '1',
      '2',
      '3',
      '4',
      '3',
      '0',
      '4',
      '4',
      '0',
      '0',
      '0',
      '2',
      '3',
      NULL,
      '',
      '1',
      '',
      '1',
      '4',
      '0',
      '0',
      '4',
      '',
      '',
      '2',
      '1',
      '4',
      '2',
      NULL,
      '2',
      '2',
      '0',
      '2',
      '0',
      '3',
      '321',
      '41201401',
      10,
      33,
      '0404223',
      NULL,
      22,
      3,
      0,
      '442001',
      4,
      ' 2- 6-1987',
      ' 5-13-2000',
      NULL,
      198.571738,
      4,
      1,
      8,
      NULL,
      60,
      NULL,
      21,
      8.456263,
      7.775489,
      NULL,
      NULL,
      9,
      5.346851,
      10,
      22,
      6.371661,
      NULL,
      2.279133,
      43,
      0,
      113,
      6,
      0.105740,
      110,
      149,
      27.710329,
      208.148539,
      NULL,
      NULL,
      NULL,
      45,
      8,
      4,
      15.690032,
      138,
      138.267414,
      ' 0-12-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      51.770942,
      13,
      NULL,
      3.218208,
      7,
      6.894953,
      NULL,
      1,
      2,
      NULL,
      1,
      1,
      60.850537,
      NULL,
      0.748738,
      14,
      NULL,
      NULL,
      NULL,
      ' 1-20-1982',
      93,
      56,
      65.593253,
      NULL,
      NULL,
      27,
      NULL,
      NULL,
      52,
      16.762668,
      37,
      59,
      ' 2- 6-1974',
      19,
      10,
      19.353952,
      4.412991,
      0,
      10.008875,
      NULL,
      ' 6-12-1981',
      NULL,
      19,
      NULL,
      7,
      NULL,
      2,
      NULL,
      14.489707,
      NULL,
      0,
      6,
      0.845733,
      84,
      15.830793,
      1,
      NULL,
      21,
      NULL,
      NULL,
      NULL,
      1.912791,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '11- 9-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-11-1991',
      NULL,
      ' 4-19-2001',
      11,
      10.804273,
      ' 8-16-1990',
      21.411479,
      73,
      ' 7-29-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      ' 7- 5-1992',
      7.398562,
      NULL,
      NULL,
      ' 2- 8-1991',
      0.520828,
      9.142882,
      ' 4-15-1979',
      14.292751,
      NULL,
      20.179980,
      16,
      ' 4-26-1979',
      16.851928,
      0,
      24.061605,
      ' 2- 0-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


