set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9608507';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      '2',
      '0',
      NULL,
      '4',
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      '2',
      '2',
      '0',
      '2',
      '1',
      '1',
      '4',
      NULL,
      '2',
      '4',
      NULL,
      '2',
      NULL,
      '',
      NULL,
      '',
      '4',
      '0',
      '3',
      '1',
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      '4',
      '2',
      NULL,
      '0',
      '3',
      '1',
      '4',
      NULL,
      '3',
      '032',
      '42142331',
      5,
      42,
      '3010340',
      3,
      0,
      2,
      NULL,
      NULL,
      NULL,
      '11-15-2003',
      NULL,
      NULL,
      NULL,
      19.046892,
      2,
      20.700847,
      10,
      NULL,
      8,
      4.209220,
      NULL,
      15.742404,
      6,
      25.034882,
      11.443449,
      4,
      15.248659,
      13,
      0.232708,
      64,
      8,
      2,
      5.320528,
      64,
      13.009852,
      0.095733,
      56.276253,
      NULL,
      19,
      94,
      0,
      58,
      ' 7- 4-1989',
      35,
      NULL,
      NULL,
      20,
      NULL,
      189.652691,
      ' 3-14-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      73,
      NULL,
      10.436967,
      23.241510,
      2.035953,
      7,
      '11-23-1978',
      1.479312,
      1,
      118,
      NULL,
      0,
      43,
      0.166729,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-27-2003',
      55.661760,
      NULL,
      NULL,
      NULL,
      72.909999,
      127,
      22,
      106.992774,
      NULL,
      NULL,
      103,
      NULL,
      ' 6-13-1998',
      22,
      0,
      8,
      NULL,
      78,
      69,
      5.065449,
      ' 9-19-1998',
      NULL,
      1,
      ' 2-21-1975',
      5.593272,
      7,
      13,
      3,
      18.118108,
      6.004849,
      NULL,
      19,
      1.888422,
      10,
      1,
      1.255714,
      21.191632,
      3,
      3.181573,
      NULL,
      NULL,
      NULL,
      ' 6-26-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      100,
      8.221795,
      ' 1-13-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-27-1986',
      NULL,
      NULL,
      NULL,
      4,
      ' 3- 5-2001',
      85,
      129.317887,
      ' 9-21-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1,
      ' 2-11-2002',
      27.942193,
      10.021807,
      27,
      ' 6-12-1974',
      0.246031,
      282.403450,
      '11-22-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


