set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9798364';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      '3',
      '4',
      '2',
      '2',
      '0',
      '2',
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      '1',
      '2',
      '3',
      '3',
      '1',
      '0',
      NULL,
      '1',
      '1',
      NULL,
      '0',
      '',
      '1',
      '',
      '4',
      '0',
      '3',
      '2',
      '4',
      '',
      NULL,
      '2',
      '3',
      '4',
      '4',
      '2',
      NULL,
      '2',
      '2',
      '1',
      '4',
      NULL,
      NULL,
      '04213322',
      34.553042,
      NULL,
      NULL,
      1.872940,
      NULL,
      0,
      NULL,
      '012204',
      2,
      ' 1-10-1996',
      NULL,
      181.039768,
      NULL,
      26.774851,
      9,
      3,
      11.254674,
      9,
      8,
      9,
      11,
      NULL,
      9.247697,
      35,
      2.677332,
      33.405293,
      26,
      NULL,
      NULL,
      43,
      NULL,
      15.308251,
      7.354471,
      135,
      29.336463,
      NULL,
      76.393631,
      117.094900,
      3.882995,
      12,
      193,
      15,
      NULL,
      NULL,
      NULL,
      32,
      30.504190,
      12,
      14.674572,
      ' 5-14-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25,
      38,
      NULL,
      22.202612,
      NULL,
      0,
      ' 1-16-1984',
      0.132548,
      1.179656,
      NULL,
      0,
      0.197528,
      83,
      NULL,
      3.530263,
      30,
      NULL,
      NULL,
      NULL,
      ' 4-20-1996',
      83,
      112,
      41,
      103.083404,
      NULL,
      27,
      79.369336,
      45,
      49.787144,
      14,
      28,
      38,
      ' 3- 2-1994',
      18.141724,
      5,
      7.128776,
      NULL,
      13,
      27,
      9,
      ' 1-24-1987',
      21,
      5.638743,
      ' 3-26-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      140,
      1.437487,
      ' 5- 0-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-23-1994',
      26,
      ' 4-27-1993',
      13.691636,
      4,
      ' 4- 6-1974',
      54,
      79.676223,
      '11-18-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      7.386052,
      ' 2- 6-2003',
      61.596409,
      24,
      16,
      ' 8-14-1987',
      1.781508,
      27.813269,
      ' 2-23-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


