set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9335168';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1220',
      '43441333',
      '42120232',
      NULL,
      '21304342',
      '11214431',
      NULL,
      '40221103',
      '31323301',
      '33342014',
      NULL,
      '11444000',
      '32324024',
      '12040000',
      '01113141',
      '20311312',
      NULL,
      '10234004',
      '13242323',
      '32414312',
      '33212344',
      '42033004',
      '34343330',
      NULL,
      '01210121',
      '03200342',
      '10444041',
      NULL,
      '23312114',
      '33412324',
      '22241240',
      NULL,
      '23143144',
      '44413444',
      '23123443',
      NULL,
      '42411334',
      NULL,
      NULL,
      '13400410',
      NULL,
      '41033412',
      '10323112',
      '24210430',
      '11300213',
      '420',
      '10',
      NULL,
      NULL,
      '1340223',
      0,
      NULL,
      1,
      NULL,
      '220123',
      NULL,
      ' 7- 9-2003',
      ' 9-19-1988',
      28.209724,
      NULL,
      38.373497,
      9.203738,
      3,
      NULL,
      72.546736,
      0.468466,
      9.335905,
      22.600539,
      18,
      NULL,
      20.921484,
      NULL,
      8.695310,
      14.744086,
      NULL,
      9,
      34,
      3,
      28.097104,
      10.221959,
      48.739934,
      11.885173,
      1,
      36.309698,
      NULL,
      58.913556,
      146.153147,
      157,
      158.449538,
      ' 1- 6-1987',
      NULL,
      69.519684,
      35.123782,
      35.860795,
      NULL,
      NULL,
      NULL,
      1.258885,
      0.682657,
      7.620363,
      1.363210,
      2.598697,
      1,
      0,
      NULL,
      1.825995,
      1.470183,
      NULL,
      0,
      1.837197,
      NULL,
      1,
      1,
      0.162070,
      1,
      0.000820,
      0.523734,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-20-1991',
      NULL,
      6,
      12,
      6.619540,
      3,
      7,
      ' 6-16-1994',
      0,
      1,
      NULL,
      1,
      NULL,
      29.913632,
      0.879549,
      4,
      23,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      87,
      NULL,
      NULL,
      NULL,
      NULL,
      58,
      13,
      NULL,
      70,
      ' 6- 0-1979',
      4.887921,
      NULL,
      15.978737,
      68,
      5.341242,
      102.795903,
      6.011134,
      NULL,
      NULL,
      4,
      '10-26-1993',
      5.974392,
      15.760580,
      9.372343,
      21.304422,
      12.682119,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      9,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.396886,
      NULL,
      ' 9-18-1977',
      81.212358,
      11,
      ' 8-10-1999',
      14,
      22.120618,
      '11- 9-1979',
      12.615304,
      ' 4-13-1998',
      3.947939,
      ' 0-12-1990',
      0.702771,
      NULL,
      ' 0-22-1978',
      52,
      130.676243,
      '10- 8-1985',
      0,
      4,
      ' 0-28-1979',
      NULL,
      NULL,
      NULL,
      0,
      0,
      13,
      ' 8- 3-1998',
      48.631708,
      22,
      32.625688,
      ' 1- 1-1974',
      NULL,
      66,
      ' 7- 9-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0);
commit;
end;
/


