set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9706710';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1034',
      '33413211',
      '33331324',
      '41112242',
      '32234413',
      '12131030',
      '00212314',
      NULL,
      '20032203',
      '31202102',
      '14330311',
      '11200322',
      '44004243',
      NULL,
      NULL,
      NULL,
      NULL,
      '01004401',
      NULL,
      '13220220',
      '13232133',
      '41041210',
      '23140403',
      NULL,
      '10023004',
      '24030142',
      '42312224',
      NULL,
      '13221112',
      NULL,
      '44303321',
      '13033113',
      '32130343',
      '33203024',
      '13012333',
      '44210114',
      NULL,
      '33403142',
      '43114440',
      '21241120',
      '40034004',
      '34121204',
      '23400200',
      '43044212',
      '14222043',
      '334',
      '32',
      12,
      NULL,
      '2303334',
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      ' 5- 3-1994',
      NULL,
      4.321041,
      76,
      4,
      0.255878,
      20,
      NULL,
      18,
      NULL,
      NULL,
      3.229278,
      10.651000,
      5.593434,
      NULL,
      NULL,
      8,
      12,
      18,
      8,
      16.192772,
      2,
      55,
      8.317396,
      16,
      NULL,
      0.343654,
      38,
      75.566304,
      57.376418,
      35.718775,
      70.690784,
      75.743418,
      NULL,
      39,
      32.408772,
      27,
      29,
      37.854022,
      147,
      '10-26-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      7.381159,
      NULL,
      9.665404,
      0.770878,
      NULL,
      NULL,
      2,
      0.728256,
      27,
      0,
      1.349016,
      30,
      NULL,
      1.532554,
      29,
      NULL,
      NULL,
      NULL,
      ' 8-25-2000',
      3,
      91.384750,
      7.961995,
      87.595716,
      53,
      62.531476,
      42.805741,
      43,
      77.285692,
      22.389053,
      18,
      51.976402,
      NULL,
      NULL,
      NULL,
      5,
      15.076785,
      19,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      74.769375,
      8.822471,
      ' 1-18-1979',
      NULL,
      NULL,
      NULL,
      35,
      ' 6-12-1985',
      NULL,
      NULL,
      11.474698,
      NULL,
      ' 4-15-1980',
      29,
      61.435971,
      ' 8-10-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      ' 7-10-2000',
      NULL,
      11,
      29.844122,
      ' 6-18-1980',
      0.520949,
      162,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


