set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9757871';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '4',
      '2',
      '4',
      '2',
      '4',
      '3',
      '2',
      '3',
      '0',
      '4',
      '4',
      NULL,
      '4',
      '1',
      '2',
      '2',
      '1',
      '0',
      '2',
      '4',
      '0',
      '1',
      '4',
      '',
      NULL,
      '',
      '0',
      '2',
      '3',
      '3',
      NULL,
      '',
      NULL,
      '2',
      '0',
      '3',
      '3',
      '4',
      '0',
      '2',
      NULL,
      '4',
      '3',
      '2',
      '404',
      '42403231',
      18,
      57.035134,
      '0240303',
      0,
      0.968926,
      NULL,
      0,
      '300002',
      0.500847,
      ' 7-10-1984',
      ' 5-24-1984',
      94,
      26.613967,
      1.684776,
      16,
      6.880249,
      15.449387,
      39,
      NULL,
      0,
      0,
      19,
      10,
      37,
      15,
      16.547919,
      10,
      16.581329,
      NULL,
      NULL,
      12.866478,
      46.968412,
      5.706242,
      6.717188,
      10.712097,
      0,
      NULL,
      34,
      43.676655,
      58,
      162,
      163.500994,
      ' 2-28-2000',
      48,
      16,
      NULL,
      38,
      152.428309,
      186,
      ' 8-24-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      26.715071,
      28,
      NULL,
      12,
      1.033568,
      4,
      ' 7-29-1990',
      NULL,
      1.360502,
      76.293896,
      1.817465,
      0.934802,
      35.121216,
      1,
      1,
      86,
      NULL,
      NULL,
      NULL,
      '10- 2-1974',
      23.182756,
      NULL,
      3,
      NULL,
      80.523291,
      NULL,
      51.823903,
      77.670302,
      11,
      19.703580,
      63.955652,
      44.785058,
      ' 1-21-1979',
      26,
      NULL,
      1.487709,
      NULL,
      38.953705,
      45,
      NULL,
      NULL,
      12,
      NULL,
      ' 6- 8-1995',
      15.143920,
      19,
      20.688496,
      26.589320,
      NULL,
      11,
      1,
      2.806035,
      NULL,
      16,
      1.296602,
      1.879609,
      22,
      29.816750,
      0.707637,
      0,
      1.633714,
      0,
      '10- 3-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      143.430871,
      26.111475,
      ' 3- 5-1998',
      NULL,
      NULL,
      NULL,
      33.867698,
      NULL,
      NULL,
      ' 2- 2-1980',
      NULL,
      NULL,
      ' 4- 6-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      14,
      ' 1-19-1980',
      37.347332,
      NULL,
      34.953021,
      NULL,
      2,
      81,
      ' 6- 6-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


