set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9717517';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '3',
      '3',
      '1',
      '4',
      '1',
      '2',
      '4',
      '0',
      '1',
      '0',
      '4',
      NULL,
      '3',
      '1',
      '3',
      '3',
      '4',
      '3',
      '3',
      '1',
      NULL,
      '3',
      '',
      NULL,
      '',
      '4',
      '3',
      '4',
      NULL,
      '1',
      '',
      '',
      NULL,
      '4',
      '3',
      '3',
      '1',
      '2',
      '0',
      NULL,
      NULL,
      '3',
      '0',
      '044',
      '42',
      0.642589,
      22,
      NULL,
      0.381900,
      0.972572,
      0,
      NULL,
      '343134',
      5,
      ' 0- 9-1980',
      ' 2- 6-1976',
      67.585156,
      62.601301,
      NULL,
      NULL,
      9.327390,
      8,
      20.934403,
      15.346416,
      8,
      5,
      NULL,
      NULL,
      38,
      NULL,
      13,
      NULL,
      5.014134,
      13.747715,
      41,
      16.144157,
      46,
      NULL,
      94.447699,
      13.817872,
      0.251780,
      NULL,
      53,
      3,
      1,
      18,
      NULL,
      ' 8-14-1994',
      NULL,
      0.803133,
      30,
      23,
      NULL,
      211.107594,
      ' 8-11-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      85.998149,
      11,
      8.460510,
      NULL,
      NULL,
      7,
      ' 4-20-1990',
      0,
      0,
      143.955685,
      NULL,
      7,
      79,
      0,
      NULL,
      29.801706,
      NULL,
      NULL,
      NULL,
      '10-25-1996',
      16.883604,
      30,
      NULL,
      43.864226,
      29.820471,
      2,
      8.492159,
      NULL,
      19,
      54,
      16,
      60.964572,
      '10-29-1974',
      3,
      12,
      7,
      7,
      NULL,
      0.983282,
      1.949504,
      ' 7-17-1997',
      10.419192,
      9,
      NULL,
      3.119002,
      14,
      10.631301,
      NULL,
      15.443312,
      5,
      3,
      18.961461,
      1,
      39.577048,
      3.898376,
      0,
      10,
      7.120265,
      2,
      1.650989,
      NULL,
      0.885915,
      ' 8- 3-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      55,
      4.596353,
      ' 0-24-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-18-1994',
      NULL,
      ' 4-12-1997',
      NULL,
      15.727806,
      '11- 8-1976',
      58,
      24.621184,
      ' 1-23-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      ' 8-20-1979',
      NULL,
      15,
      4.847213,
      ' 5-22-1983',
      0,
      63,
      ' 7-24-1993',
      15,
      NULL,
      12.565481,
      68.385092,
      ' 5- 6-1985',
      35,
      1,
      102,
      '10- 4-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


