set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9717517';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '4',
      '2',
      '3',
      '1',
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      '2',
      '3',
      '3',
      '1',
      '1',
      '3',
      '2',
      '1',
      '1',
      NULL,
      NULL,
      '0',
      '',
      '1',
      NULL,
      '1',
      '2',
      '3',
      '',
      '',
      '0',
      '0',
      '2',
      '2',
      '2',
      '3',
      '2',
      '2',
      '4',
      '3',
      '0',
      '322',
      '34220410',
      22,
      47.767788,
      '0030333',
      0.489181,
      20.656698,
      2,
      NULL,
      NULL,
      5.207408,
      ' 9-24-1991',
      NULL,
      NULL,
      84,
      2,
      16,
      5.817771,
      14,
      76,
      5,
      12.015319,
      12,
      27.746871,
      NULL,
      13.016335,
      NULL,
      NULL,
      20,
      16.055365,
      5.214891,
      14,
      16,
      53.223648,
      11.997083,
      37.749763,
      11,
      1.928522,
      43.738023,
      116,
      85.798316,
      17.964427,
      174.621257,
      2,
      NULL,
      NULL,
      65,
      NULL,
      17,
      184.830260,
      109.428140,
      ' 1- 8-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      38,
      NULL,
      6,
      NULL,
      4,
      9,
      ' 1- 6-2001',
      1,
      0.490414,
      18,
      1.127571,
      1.851230,
      123,
      0.210686,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24,
      35.652530,
      57,
      58.249453,
      44,
      6,
      44.756599,
      35.450533,
      39,
      NULL,
      16,
      61,
      ' 0-16-1986',
      12.419302,
      NULL,
      11.010687,
      NULL,
      NULL,
      6.026833,
      6,
      ' 5-26-1984',
      NULL,
      15,
      ' 0- 4-1974',
      13.883773,
      9,
      2.232717,
      9,
      15,
      NULL,
      0,
      4.844737,
      1.897518,
      50,
      0.753856,
      1,
      19.324566,
      8.702547,
      1.913217,
      0.431385,
      1.164564,
      0.569243,
      ' 9- 2-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      54,
      8.473302,
      '10-20-1981',
      NULL,
      NULL,
      NULL,
      19.332290,
      NULL,
      NULL,
      NULL,
      18.840081,
      5.113017,
      ' 1-11-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.610611,
      NULL,
      3,
      11,
      NULL,
      ' 8-21-1993',
      0.793695,
      36.023557,
      ' 2- 1-1975',
      7.366985,
      179.215170,
      19.254049,
      NULL,
      NULL,
      NULL,
      1,
      2,
      ' 0- 7-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


