set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9717517';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      '0',
      '4',
      '3',
      '3',
      '0',
      '1',
      '0',
      NULL,
      NULL,
      '1',
      '2',
      '0',
      '2',
      '4',
      '4',
      '0',
      '3',
      NULL,
      '1',
      '4',
      '1',
      NULL,
      '',
      '3',
      '',
      '3',
      '2',
      '4',
      '2',
      '1',
      '',
      '',
      '3',
      '4',
      NULL,
      '2',
      NULL,
      '4',
      '2',
      '0',
      '2',
      '0',
      '1',
      '243',
      '40441131',
      30,
      NULL,
      '0441221',
      NULL,
      4.157971,
      3,
      1,
      '102302',
      2,
      ' 8-22-1983',
      ' 9-28-1994',
      31,
      151,
      3,
      6.154048,
      11,
      3.560345,
      42.148680,
      NULL,
      1,
      NULL,
      14.734703,
      0,
      14,
      11,
      12,
      NULL,
      12.104531,
      2.514004,
      44.117183,
      10,
      40,
      NULL,
      20.933608,
      NULL,
      NULL,
      85,
      114.510586,
      47.112713,
      61.484596,
      83,
      45.366307,
      '11- 7-1980',
      3,
      14.143289,
      1,
      NULL,
      31.611897,
      180.290705,
      '10- 7-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.957204,
      45,
      NULL,
      23,
      NULL,
      5,
      NULL,
      1.978903,
      NULL,
      46.192014,
      NULL,
      NULL,
      87,
      0,
      1.934216,
      26.302776,
      NULL,
      NULL,
      NULL,
      ' 6-27-2002',
      6.525620,
      NULL,
      10.328115,
      37.257525,
      13,
      28.631785,
      30,
      NULL,
      22,
      2,
      28.727960,
      66,
      NULL,
      NULL,
      1,
      16,
      8.338621,
      24,
      NULL,
      3.841234,
      ' 2-16-1980',
      0,
      0,
      ' 9-26-1997',
      11,
      12.583876,
      22,
      23,
      21,
      7,
      1,
      5,
      NULL,
      21.443221,
      NULL,
      5.416142,
      22.879928,
      26,
      0,
      NULL,
      NULL,
      1.814800,
      ' 1- 7-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      48.677267,
      0.751907,
      ' 2- 4-2000',
      NULL,
      NULL,
      NULL,
      50,
      ' 2- 8-2000',
      40.882525,
      '10-22-1994',
      6.910374,
      10,
      ' 9- 0-1975',
      24.439556,
      96,
      ' 5- 9-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      ' 4-19-1998',
      50,
      24,
      1.845835,
      ' 8-21-1989',
      0.947987,
      86,
      ' 1- 4-1989',
      15.554019,
      6,
      NULL,
      42,
      NULL,
      31,
      NULL,
      9.068765,
      ' 9-26-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


