set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8828666';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '2',
      '1',
      '1',
      '3',
      '0',
      '0',
      '4',
      NULL,
      '0',
      '1',
      '0',
      '3',
      NULL,
      '3',
      '1',
      '3',
      '4',
      NULL,
      '0',
      '2',
      '2',
      '3',
      '1',
      '',
      '3',
      '',
      '1',
      '1',
      NULL,
      '2',
      '3',
      '',
      '',
      '3',
      '4',
      NULL,
      '3',
      '1',
      NULL,
      '3',
      '2',
      '4',
      '0',
      '4',
      '020',
      '32',
      NULL,
      30,
      '2331204',
      2,
      48.392047,
      3,
      NULL,
      '021324',
      3,
      ' 6- 0-1990',
      '11-22-1974',
      NULL,
      67.618007,
      5.547116,
      25.574363,
      0,
      12.830909,
      84.574380,
      NULL,
      12.782225,
      8.439923,
      37.251275,
      NULL,
      45.622961,
      20,
      26,
      34,
      29.037524,
      NULL,
      NULL,
      NULL,
      42.283220,
      NULL,
      49,
      0,
      1.621528,
      99.736403,
      201.818633,
      115.884332,
      94.837270,
      180,
      84,
      ' 6-14-1979',
      NULL,
      1.817434,
      3,
      NULL,
      167,
      183,
      ' 3-10-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      64,
      NULL,
      4.266954,
      1.574006,
      8,
      3.189762,
      ' 2- 0-1992',
      1.890735,
      NULL,
      18,
      1.668277,
      0.050656,
      139,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      94.382730,
      69.710931,
      NULL,
      6,
      50,
      NULL,
      18,
      12,
      71.310886,
      77,
      NULL,
      67.589748,
      ' 5-20-1992',
      13,
      3.439211,
      15,
      42.214337,
      10.932193,
      104.100175,
      NULL,
      ' 2- 6-2000',
      2.462185,
      NULL,
      ' 8-20-2000',
      7,
      15.911379,
      6.933989,
      3.346901,
      23,
      NULL,
      0.008218,
      NULL,
      NULL,
      18,
      0,
      8.823099,
      2,
      0.887128,
      2.160604,
      3,
      9.890035,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      46,
      0,
      ' 5- 5-1998',
      NULL,
      NULL,
      NULL,
      12,
      ' 9-25-2003',
      5.646962,
      NULL,
      8.837870,
      1,
      ' 4-13-2003',
      25.491550,
      47.501779,
      ' 7- 2-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      18,
      ' 0-23-1975',
      NULL,
      46,
      9.999309,
      ' 1-21-1974',
      1.955854,
      NULL,
      ' 9-16-1986',
      19,
      15,
      6,
      14.774303,
      ' 9- 6-1998',
      72,
      0,
      21,
      '10-11-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


