set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9010379';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3004',
      '44144213',
      '23124041',
      '04014321',
      '20012234',
      NULL,
      '30244001',
      '43210031',
      '24000424',
      '44113202',
      '10130441',
      NULL,
      '13114313',
      '04011122',
      '21123342',
      NULL,
      '14201132',
      '00233321',
      '31443311',
      '24134211',
      '40031231',
      '43024231',
      '23001004',
      '24014014',
      '33313410',
      '30311300',
      '44341122',
      '01032231',
      NULL,
      NULL,
      '12401204',
      '22344232',
      NULL,
      '20101243',
      '33214010',
      '34311120',
      NULL,
      '12413421',
      '41003023',
      NULL,
      '32224211',
      '41343003',
      '02212420',
      '30134014',
      '24133342',
      '',
      '',
      NULL,
      NULL,
      '2240322',
      0,
      NULL,
      0,
      NULL,
      '343001',
      3.689541,
      ' 0-22-1995',
      ' 2-20-1976',
      NULL,
      NULL,
      4,
      4.490026,
      NULL,
      NULL,
      55,
      8.245114,
      NULL,
      NULL,
      19,
      1.756154,
      28,
      NULL,
      20,
      3.067971,
      2.652591,
      6,
      44.500812,
      NULL,
      19,
      NULL,
      23,
      1,
      NULL,
      NULL,
      161.143402,
      NULL,
      33,
      61.135387,
      114.940209,
      ' 0-26-1990',
      30.658410,
      44,
      NULL,
      8.091524,
      160,
      46.110472,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.371122,
      NULL,
      1,
      1.916211,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-29-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      80,
      39,
      19.615040,
      83.165992,
      16,
      21.750569,
      21,
      61.174486,
      62,
      14,
      NULL,
      1,
      ' 8-19-1991',
      NULL,
      3.181448,
      NULL,
      38.402444,
      2.058823,
      3.549104,
      7,
      ' 1- 6-2002',
      8.221947,
      NULL,
      ' 2-21-1996',
      4.930025,
      7,
      6,
      10,
      7,
      2,
      NULL,
      NULL,
      NULL,
      65.821798,
      1,
      1.965104,
      2.220809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-18-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18,
      3.458920,
      ' 1-20-1988',
      1.576264,
      62,
      NULL,
      11.395971,
      2,
      20.379655,
      11,
      NULL,
      55.404272,
      1,
      55,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      61,
      NULL,
      48.659939,
      8.677971,
      12,
      NULL,
      7,
      47.481635,
      0.379317,
      NULL,
      36.463548,
      NULL,
      NULL,
      NULL,
      0,
      2,
      102,
      0,
      1.198747,
      189,
      37.015482,
      27,
      NULL,
      1,
      62.013782,
      NULL,
      NULL,
      1.673885,
      0.059556,
      NULL,
      0,
      NULL,
      32,
      34,
      9,
      54.076941,
      38,
      0.988084,
      1.187708,
      28.807374,
      1,
      1,
      NULL,
      NULL,
      0.821335,
      32.756448,
      NULL,
      39,
      0.040750,
      0,
      6,
      6,
      5.883616,
      7.734362,
      NULL,
      22.298202,
      NULL,
      22,
      1,
      22,
      4,
      9,
      2,
      0.956195,
      0.452487,
      0.786312,
      32.677320,
      NULL,
      ' 9-24-2000',
      NULL,
      NULL,
      ' 7- 6-2003',
      NULL,
      NULL,
      NULL);
commit;
end;
/


