set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9010379';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '00133000',
      '30301122',
      '33010114',
      '04132300',
      NULL,
      '00443013',
      NULL,
      NULL,
      NULL,
      '41041124',
      '33420412',
      '12340041',
      NULL,
      '44412012',
      '04433343',
      NULL,
      NULL,
      '22031341',
      '24124300',
      '44111242',
      '02001434',
      '33204033',
      '43104412',
      NULL,
      '34041314',
      '02210031',
      NULL,
      '11002033',
      '32432031',
      '32234302',
      '24444322',
      '43022401',
      '34320224',
      '02344124',
      '01230213',
      '41314433',
      '13344010',
      NULL,
      '23311412',
      '13112134',
      '14102313',
      '02204311',
      NULL,
      '00113003',
      '443',
      '03',
      NULL,
      NULL,
      '3134012',
      2,
      32.935070,
      1,
      NULL,
      NULL,
      NULL,
      ' 6-27-1988',
      ' 1- 4-1982',
      28,
      NULL,
      NULL,
      16.161581,
      2.920024,
      17.072867,
      19,
      8.227752,
      10,
      7.677327,
      7,
      NULL,
      23,
      2.919134,
      18,
      12.961985,
      13.502288,
      2.426039,
      8,
      14,
      NULL,
      8.685286,
      13.104654,
      NULL,
      0.458817,
      45,
      122,
      NULL,
      34.612222,
      36,
      23.673810,
      ' 2- 0-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22,
      13.012028,
      7.178509,
      NULL,
      5,
      5,
      NULL,
      1,
      NULL,
      192,
      1,
      1,
      50,
      0.067314,
      0,
      79,
      1,
      1.946020,
      127.584898,
      ' 7-21-1997',
      109,
      94.741302,
      NULL,
      5,
      46.660586,
      27,
      6.733401,
      3.642573,
      39,
      30,
      87,
      38,
      ' 7-28-1983',
      10,
      0,
      NULL,
      32,
      0,
      0.578887,
      1.692733,
      NULL,
      5,
      19.402691,
      ' 8- 7-1975',
      NULL,
      NULL,
      15.568684,
      9.624208,
      10.917289,
      2.049819,
      0,
      2,
      NULL,
      11.825341,
      NULL,
      0,
      6.129996,
      12.672222,
      1,
      1.473069,
      3,
      3.127155,
      ' 9-18-1979',
      1.157805,
      2,
      2.737350,
      ' 1-12-1975',
      64,
      1.492360,
      ' 0-11-1974',
      NULL,
      NULL,
      NULL,
      1,
      ' 6-28-1976',
      32,
      ' 6-22-1998',
      1.544041,
      3,
      ' 5- 7-1988',
      37.374326,
      NULL,
      ' 0- 1-2000',
      5.698760,
      0.714424,
      ' 8-11-2003',
      1.748592,
      1,
      ' 6-29-1981',
      2,
      3,
      NULL,
      ' 4-16-1987',
      1.656682,
      NULL,
      21,
      ' 6-25-2003',
      1.255226,
      81,
      ' 3-25-1996',
      2.546802,
      NULL,
      12.849589,
      NULL,
      ' 4-16-1975',
      41,
      0,
      67,
      ' 3-19-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


