set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9010379';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      '44332340',
      '01213123',
      '33240412',
      NULL,
      '42031413',
      '00110140',
      '02411410',
      '41112442',
      '04310331',
      NULL,
      NULL,
      '24211113',
      '41030313',
      '23021243',
      '11332033',
      '11424000',
      NULL,
      NULL,
      '43243104',
      '41312212',
      '01240201',
      '44321214',
      '20034040',
      '43123102',
      '14022320',
      '44241212',
      '04140024',
      NULL,
      '42141044',
      '22202142',
      NULL,
      NULL,
      '30120133',
      '21144300',
      '21222423',
      '34412401',
      '31304403',
      '03344142',
      '14140243',
      '10211400',
      '30042443',
      NULL,
      '343',
      '21',
      NULL,
      NULL,
      '1441343',
      3.754836,
      NULL,
      3,
      NULL,
      '322300',
      5,
      ' 5- 4-1999',
      ' 5- 5-1984',
      89,
      NULL,
      35,
      10,
      19.352751,
      4.150120,
      64.638397,
      NULL,
      3.649943,
      NULL,
      1,
      15,
      24.352053,
      5.088361,
      1.843689,
      NULL,
      13,
      3.923564,
      NULL,
      15.713070,
      16.590496,
      NULL,
      22,
      9,
      NULL,
      48,
      79,
      62.062895,
      185,
      13,
      180,
      ' 9- 6-1995',
      6.124243,
      2.579590,
      8.620442,
      33,
      18.371934,
      212.777297,
      NULL,
      0.873543,
      NULL,
      NULL,
      0.213096,
      NULL,
      0,
      NULL,
      0,
      1,
      1,
      0.458833,
      1.910300,
      NULL,
      1,
      0,
      1.162904,
      1,
      1,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-25-1993',
      NULL,
      15,
      7.795665,
      6,
      NULL,
      5.465575,
      ' 1-27-1975',
      1.404712,
      NULL,
      NULL,
      NULL,
      0.359933,
      53.034325,
      0.346663,
      0,
      72,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      89,
      59,
      87.441975,
      98,
      NULL,
      95,
      65,
      NULL,
      79,
      0.732096,
      84.841928,
      ' 6- 7-1995',
      8.246867,
      13,
      19,
      38,
      18.172766,
      2.409453,
      7,
      NULL,
      5,
      17,
      ' 0-12-1996',
      0.127385,
      9.060116,
      8,
      6.753511,
      13,
      2,
      1,
      9.967165,
      NULL,
      42.631111,
      NULL,
      3,
      NULL,
      12,
      6,
      3,
      0,
      NULL,
      ' 5- 4-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      75.233829,
      1,
      ' 8-14-1996',
      NULL,
      NULL,
      NULL,
      23.666220,
      ' 7- 3-1997',
      NULL,
      ' 3- 9-1976',
      2,
      7.419372,
      ' 5-10-1984',
      71.775615,
      78,
      ' 0- 3-1974',
      NULL,
      2,
      ' 4- 3-1998',
      NULL,
      NULL,
      NULL,
      1,
      3,
      14,
      ' 1- 4-1976',
      18,
      14,
      NULL,
      ' 8- 0-1983',
      0,
      38,
      '11- 2-2003',
      12,
      NULL,
      18.988990,
      47,
      ' 3- 4-1975',
      NULL,
      NULL,
      69,
      ' 5-25-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


