set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9797394';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      NULL,
      NULL,
      '2',
      '4',
      NULL,
      '4',
      '4',
      '0',
      '2',
      NULL,
      '2',
      '3',
      NULL,
      '4',
      NULL,
      '',
      '0',
      '',
      '0',
      NULL,
      '1',
      '1',
      '2',
      '',
      '',
      NULL,
      NULL,
      '1',
      '4',
      '4',
      '2',
      '2',
      NULL,
      NULL,
      '2',
      '0',
      '403',
      '34002101',
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      '202324',
      5,
      '10-11-1995',
      ' 9-14-1994',
      32.687146,
      147.416115,
      NULL,
      10,
      11.425477,
      0.248574,
      30,
      23.474194,
      0,
      1,
      NULL,
      6.095228,
      8.484904,
      NULL,
      0,
      3.190405,
      0.177396,
      0,
      24.890480,
      12.342530,
      18,
      NULL,
      53.510387,
      NULL,
      1.620296,
      NULL,
      58,
      10,
      90.779178,
      27,
      NULL,
      '11-21-1977',
      32,
      47.768130,
      5,
      18,
      130.542187,
      18.525544,
      ' 8- 4-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      58.561647,
      NULL,
      28,
      7,
      6.683401,
      2,
      ' 9-27-1992',
      1.506483,
      NULL,
      150.793137,
      1,
      1.237133,
      NULL,
      1.937437,
      0.006245,
      33.598222,
      NULL,
      NULL,
      NULL,
      '11-13-1978',
      28,
      6,
      4,
      8,
      5.509304,
      35,
      10.291719,
      35.686229,
      NULL,
      17,
      10.007443,
      33,
      ' 6-21-1993',
      NULL,
      29.876417,
      3.412103,
      76.390814,
      67,
      172.234362,
      1.894440,
      ' 0- 5-2002',
      1.790679,
      4.080339,
      ' 5-27-1978',
      0,
      6,
      4.773531,
      1,
      1,
      4.654361,
      0.720210,
      15,
      1.340678,
      46,
      2,
      1.226542,
      NULL,
      5,
      0.705325,
      6,
      0.674700,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      64.265602,
      NULL,
      ' 7-29-1981',
      NULL,
      NULL,
      NULL,
      17.002287,
      ' 8-19-1987',
      1.284892,
      ' 5-22-1991',
      4.770515,
      2.663426,
      ' 9- 2-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      13,
      '11-25-1974',
      NULL,
      19,
      26,
      ' 5-27-1982',
      NULL,
      66,
      ' 7-12-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


