set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9305827';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '04343112',
      '40133123',
      '11444320',
      '22320324',
      NULL,
      '42204104',
      '23431340',
      '11414220',
      '20323222',
      NULL,
      '42444204',
      '30314203',
      '34431022',
      '24201111',
      NULL,
      '42024104',
      '32343103',
      NULL,
      '24443230',
      '30033321',
      '04304204',
      '22324414',
      '21032141',
      NULL,
      '32024432',
      '33213434',
      '31122403',
      '11333041',
      '33224122',
      '21444032',
      '02302412',
      '13413114',
      '24301414',
      NULL,
      '43002241',
      '01330212',
      '20024023',
      NULL,
      NULL,
      '34342144',
      NULL,
      '24401304',
      '42221144',
      '412',
      '10',
      NULL,
      NULL,
      '0314032',
      2.395764,
      NULL,
      3,
      NULL,
      '341122',
      1.114592,
      ' 3-13-1984',
      '11- 9-1981',
      103.315174,
      NULL,
      NULL,
      7,
      9,
      6,
      45,
      18.835703,
      0.521972,
      15.913859,
      21.987113,
      15,
      0.289883,
      17.417911,
      NULL,
      3.164265,
      25,
      NULL,
      77,
      9.549468,
      36.256478,
      NULL,
      44.378053,
      8.292190,
      1.114933,
      NULL,
      190.657429,
      73,
      74.746352,
      92.657801,
      NULL,
      ' 5-23-2000',
      24.896134,
      39.586320,
      4.498160,
      35.081211,
      34,
      NULL,
      '11-18-1982',
      0,
      0.996865,
      NULL,
      NULL,
      0.218927,
      1,
      1,
      NULL,
      NULL,
      1.945569,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      1,
      1.684802,
      0.571981,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-26-1976',
      27,
      4,
      19.231198,
      11,
      13,
      NULL,
      NULL,
      NULL,
      1.174273,
      131.083355,
      0,
      0,
      55.775858,
      1.005846,
      0,
      47,
      0.724673,
      1.743611,
      24,
      ' 2-19-1993',
      68.864870,
      54,
      NULL,
      91,
      98,
      NULL,
      53.995518,
      NULL,
      40.337857,
      59.328995,
      20,
      NULL,
      '10-19-1984',
      21,
      11,
      0.187750,
      8.680467,
      24,
      62,
      4.931554,
      ' 2-21-1985',
      19.010924,
      10.452857,
      '10- 3-1991',
      13,
      17.899617,
      20,
      NULL,
      14.319412,
      3.453050,
      1,
      10.644510,
      0.259815,
      93.872567,
      NULL,
      9.822364,
      7.106026,
      NULL,
      4,
      NULL,
      4.954145,
      NULL,
      ' 4- 7-1999',
      7,
      3,
      0,
      NULL,
      NULL,
      6,
      '10-17-1990',
      46.845306,
      15,
      NULL,
      NULL,
      NULL,
      48,
      '11- 7-1976',
      0,
      6,
      ' 3-11-1975',
      148.972623,
      1.714404,
      ' 1-28-1976',
      NULL,
      NULL,
      '10-14-2003',
      NULL,
      2.817350,
      ' 2- 2-2003',
      3,
      2,
      0,
      ' 1- 3-2003',
      33.652371,
      28,
      13,
      '11-20-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


