set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9849772';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '4',
      NULL,
      NULL,
      '0',
      '0',
      '2',
      '1',
      NULL,
      '1',
      NULL,
      '2',
      '0',
      '3',
      '2',
      NULL,
      '2',
      NULL,
      '1',
      '2',
      '3',
      NULL,
      '0',
      NULL,
      NULL,
      '1',
      '',
      NULL,
      NULL,
      '1',
      '4',
      '3',
      '',
      '',
      NULL,
      '4',
      '4',
      '0',
      '0',
      '2',
      '0',
      NULL,
      '3',
      '2',
      '1',
      '304',
      '21432422',
      NULL,
      56.381566,
      '4402412',
      3,
      1.535646,
      NULL,
      NULL,
      '223433',
      4.478598,
      NULL,
      ' 1-24-1996',
      21.638429,
      NULL,
      6.606827,
      1,
      36.600640,
      NULL,
      89,
      13,
      19.638826,
      15,
      6.089728,
      0,
      NULL,
      17,
      3.980057,
      NULL,
      NULL,
      4.150810,
      NULL,
      15.543002,
      44,
      1.248965,
      37.343632,
      14,
      0.475343,
      6,
      131.043260,
      11.044418,
      113,
      82,
      NULL,
      '11- 2-2002',
      0,
      NULL,
      8.789512,
      11.921859,
      76,
      114.634048,
      '11- 1-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.279269,
      NULL,
      10.163328,
      NULL,
      2,
      ' 6-23-1974',
      1,
      1,
      110,
      1,
      0,
      53,
      3,
      3,
      111,
      NULL,
      NULL,
      NULL,
      ' 8-12-1998',
      13,
      8,
      3.212549,
      31.758313,
      NULL,
      101.612583,
      29,
      42,
      61.693065,
      49,
      88.606331,
      21,
      NULL,
      5.703552,
      17,
      4,
      5,
      75,
      NULL,
      7,
      ' 8-13-2001',
      17.278401,
      14,
      ' 2- 3-1977',
      1,
      0.655519,
      16.660179,
      11,
      25,
      8,
      0.051208,
      19,
      NULL,
      66.154696,
      0.536887,
      0.340711,
      4,
      3.248695,
      4.131039,
      NULL,
      NULL,
      NULL,
      ' 3- 2-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      145,
      34.066556,
      ' 9- 9-1989',
      NULL,
      NULL,
      NULL,
      60.721575,
      NULL,
      41,
      ' 1-26-1987',
      1,
      5.373387,
      ' 2- 8-2001',
      129.568971,
      35,
      ' 3- 7-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.184564,
      NULL,
      41,
      NULL,
      7.160275,
      NULL,
      0,
      37.428721,
      '11-16-1987',
      8.489908,
      6.904582,
      19.281193,
      9,
      ' 5-23-1982',
      2.400186,
      NULL,
      77.867882,
      ' 0-11-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


