set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9127727';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '3',
      '3',
      NULL,
      '0',
      '0',
      '2',
      '2',
      '2',
      NULL,
      '2',
      NULL,
      '0',
      '0',
      '0',
      '1',
      '1',
      NULL,
      '2',
      NULL,
      '2',
      NULL,
      '2',
      '4',
      '',
      NULL,
      NULL,
      '4',
      NULL,
      '1',
      '0',
      '4',
      NULL,
      '',
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '4',
      '4',
      '2',
      NULL,
      '0',
      NULL,
      '10332334',
      44,
      52,
      '0021310',
      1,
      0.688976,
      2,
      NULL,
      NULL,
      1,
      ' 9- 8-2000',
      ' 8-13-1986',
      80,
      37.891668,
      32,
      9,
      8.113664,
      11.097024,
      NULL,
      3,
      11,
      13,
      19.382487,
      19.722818,
      0.740310,
      NULL,
      NULL,
      NULL,
      1.860074,
      9,
      NULL,
      3.564180,
      37,
      NULL,
      15.062565,
      9,
      1,
      27,
      51.999081,
      NULL,
      16.719391,
      30,
      68,
      ' 6- 0-1999',
      38.467357,
      1.918970,
      15,
      0.695516,
      43.806852,
      NULL,
      ' 1- 2-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      54,
      16,
      13.812932,
      25,
      1,
      ' 2-29-1995',
      1,
      0.096825,
      66.853050,
      NULL,
      NULL,
      107.008723,
      2,
      0,
      28.798377,
      NULL,
      NULL,
      NULL,
      ' 7- 5-2003',
      NULL,
      22,
      55.646671,
      27,
      11.666453,
      NULL,
      33,
      40,
      NULL,
      NULL,
      49.034946,
      25,
      ' 8-23-1981',
      22,
      16,
      1.913490,
      53,
      51,
      34.270406,
      NULL,
      '11- 1-1994',
      6,
      9,
      ' 6-17-1990',
      7.968732,
      6,
      7,
      12,
      8,
      6.173708,
      0.489193,
      NULL,
      0,
      57.747320,
      20,
      1,
      2.811126,
      11,
      0,
      3.110916,
      2,
      0,
      ' 0-25-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      38,
      '10- 0-1977',
      NULL,
      NULL,
      NULL,
      20.863892,
      ' 4-13-1992',
      3.899963,
      ' 0-19-1998',
      19.953473,
      6.724017,
      ' 1-28-1998',
      130,
      88.488273,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      11,
      '11-12-1989',
      31,
      9.188152,
      8,
      ' 3- 1-1980',
      3.979961,
      NULL,
      ' 0- 9-2002',
      7.731600,
      39,
      11.927094,
      35,
      ' 0- 6-1979',
      42,
      0.903800,
      59.466655,
      ' 9-20-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


