set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9127727';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '4',
      '4',
      NULL,
      '3',
      '4',
      '2',
      '1',
      '4',
      '2',
      '2',
      '3',
      '1',
      '0',
      '3',
      '3',
      NULL,
      '4',
      NULL,
      '1',
      '1',
      '1',
      '1',
      '2',
      '',
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      '1',
      '1',
      '',
      '',
      '4',
      '1',
      '0',
      '0',
      '4',
      NULL,
      '3',
      '2',
      '1',
      '0',
      '1',
      NULL,
      NULL,
      34,
      NULL,
      '0112201',
      2,
      NULL,
      3,
      1,
      NULL,
      5,
      ' 9-19-1982',
      ' 5-29-1998',
      NULL,
      181.482827,
      15,
      1.669073,
      NULL,
      13,
      46.484377,
      17,
      1,
      NULL,
      30.747554,
      4.432610,
      6.978886,
      10,
      1.636469,
      NULL,
      10.699793,
      10.192456,
      3.421093,
      7,
      7.255080,
      0,
      20,
      NULL,
      0,
      NULL,
      NULL,
      24.329614,
      NULL,
      21.552318,
      36.385870,
      ' 3- 9-1999',
      48,
      NULL,
      18,
      NULL,
      79.137149,
      9.448979,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      33.790185,
      22.554981,
      19,
      9,
      3.579175,
      ' 6-15-2000',
      0,
      2.414049,
      10.377301,
      1.038566,
      NULL,
      47.527486,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      43,
      15.112919,
      26.664824,
      15,
      NULL,
      100,
      40,
      NULL,
      2,
      26.605106,
      81,
      ' 2-10-2001',
      16.155196,
      NULL,
      18,
      35.980773,
      24.838958,
      33,
      0.782773,
      NULL,
      13.505236,
      9.432845,
      ' 2- 4-1999',
      NULL,
      12.427390,
      3.994799,
      2,
      13.107686,
      NULL,
      1,
      4.761526,
      0.547515,
      NULL,
      9,
      0,
      NULL,
      6,
      11,
      0,
      NULL,
      1,
      ' 8- 0-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      58,
      ' 1-21-1998',
      NULL,
      NULL,
      NULL,
      13.680672,
      NULL,
      31,
      NULL,
      8.358395,
      0.077730,
      '11-21-1981',
      105.077954,
      38,
      ' 4- 2-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      9,
      ' 8-11-1996',
      25.997209,
      NULL,
      7.695299,
      ' 3- 4-1998',
      0.532819,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      33.151518,
      ' 2-25-1998',
      52,
      1,
      NULL,
      ' 1- 9-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


