set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7942292';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      NULL,
      '4',
      '3',
      '3',
      NULL,
      NULL,
      '1',
      '0',
      '0',
      '2',
      '2',
      '0',
      '2',
      '2',
      '1',
      '1',
      '2',
      '4',
      '3',
      '1',
      '1',
      '0',
      '1',
      '',
      NULL,
      '',
      NULL,
      '2',
      '0',
      '1',
      NULL,
      '',
      '',
      '1',
      '4',
      '3',
      '2',
      '1',
      '0',
      NULL,
      NULL,
      '2',
      '2',
      NULL,
      '214',
      '44441434',
      17,
      20,
      '2111210',
      2.650652,
      1.661188,
      1,
      NULL,
      NULL,
      3.176706,
      ' 6-25-1986',
      NULL,
      30,
      250,
      3.554111,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      23,
      26,
      15.985703,
      13,
      11.110072,
      3,
      5,
      NULL,
      10,
      27,
      10,
      27.718669,
      11.477693,
      68,
      3,
      0.902613,
      48,
      7.421911,
      32.875633,
      100.317307,
      100,
      57,
      NULL,
      30,
      29.552719,
      NULL,
      19,
      65.611866,
      75.699999,
      ' 8-17-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25,
      11.879387,
      24,
      NULL,
      28.288960,
      7,
      ' 7-16-1995',
      1.676996,
      NULL,
      156,
      1.107763,
      0.158915,
      96,
      0.802367,
      0,
      57,
      NULL,
      NULL,
      NULL,
      '10- 4-1997',
      56.621236,
      68,
      28,
      78,
      55,
      42.090982,
      55.027682,
      NULL,
      24,
      NULL,
      62.030824,
      50,
      NULL,
      25,
      20,
      11.190971,
      22,
      0,
      NULL,
      NULL,
      ' 5-24-1995',
      8.943130,
      3.226676,
      ' 6-24-1988',
      12,
      4,
      13,
      2,
      11.986687,
      0,
      1.467461,
      6,
      0,
      34,
      NULL,
      1,
      13.985592,
      24,
      0,
      0.936104,
      1.495982,
      0.055023,
      ' 9-21-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      33.379049,
      ' 1- 0-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.107917,
      ' 5-28-1979',
      47.123689,
      NULL,
      16,
      NULL,
      3,
      117,
      ' 4-17-1990',
      0,
      40.294464,
      6.844797,
      137,
      ' 3- 1-1998',
      26.503996,
      1,
      78,
      ' 7- 4-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


