set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8314540';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '1',
      '1',
      '4',
      NULL,
      '4',
      '1',
      '1',
      '4',
      '1',
      '2',
      '2',
      '2',
      '3',
      '0',
      '4',
      '3',
      '2',
      '0',
      NULL,
      '1',
      '0',
      '2',
      '2',
      '',
      '2',
      '',
      '4',
      '2',
      '3',
      '2',
      '2',
      '',
      NULL,
      '0',
      '3',
      '1',
      '1',
      '3',
      '0',
      NULL,
      '2',
      '3',
      '0',
      '4',
      '201',
      '01042320',
      80.640979,
      11.434401,
      '4041202',
      1,
      1.778220,
      2,
      0,
      NULL,
      2.491309,
      ' 4- 5-1977',
      '11- 0-1977',
      NULL,
      NULL,
      19.874480,
      NULL,
      21,
      15.134063,
      12.325320,
      NULL,
      NULL,
      NULL,
      0.785641,
      NULL,
      17.391488,
      NULL,
      7.204220,
      7.911895,
      17.617607,
      11.206915,
      36,
      NULL,
      25,
      5.798286,
      59,
      8.608152,
      0.475764,
      48.481437,
      52.486688,
      10.968149,
      6.156321,
      NULL,
      2.173229,
      ' 3-14-1999',
      54,
      7.841411,
      7.702869,
      NULL,
      119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16.963767,
      7,
      19.843383,
      38.804322,
      5.654925,
      3.296159,
      ' 3-26-1994',
      0,
      1,
      NULL,
      0.865057,
      0.098616,
      67,
      0,
      1.128976,
      29.818255,
      NULL,
      NULL,
      NULL,
      ' 7- 6-1997',
      36.452703,
      47.174831,
      93.940040,
      41.373492,
      80.147030,
      8.464804,
      100.220262,
      52,
      NULL,
      80.774018,
      78,
      11.285882,
      ' 7- 6-1995',
      23,
      27,
      NULL,
      33,
      4,
      108.058912,
      7,
      ' 1-19-1999',
      2.619910,
      0.139916,
      '11- 7-1978',
      2.070173,
      3.538523,
      3.903626,
      2,
      NULL,
      NULL,
      0.025063,
      10.877328,
      0,
      42.510024,
      0,
      1,
      0,
      25,
      3,
      3,
      0,
      0,
      ' 7-10-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      15.982755,
      NULL,
      '11- 7-1976',
      NULL,
      NULL,
      NULL,
      7.986411,
      '10- 9-1987',
      12.410445,
      ' 3- 0-1976',
      5.855822,
      13,
      NULL,
      37,
      NULL,
      ' 5-28-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      ' 3-18-1984',
      49.707255,
      13.917736,
      NULL,
      '10- 7-1991',
      0.217841,
      239.683308,
      ' 0- 0-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


