set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9829996';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      '4',
      '3',
      '3',
      '3',
      '3',
      '3',
      '2',
      '2',
      '0',
      '1',
      '0',
      '4',
      '1',
      NULL,
      '4',
      '0',
      '3',
      '2',
      '2',
      '1',
      '1',
      '2',
      '',
      '3',
      NULL,
      '4',
      NULL,
      '0',
      NULL,
      '3',
      '',
      '',
      '3',
      '1',
      '0',
      '2',
      NULL,
      '1',
      NULL,
      '1',
      '4',
      '1',
      '2',
      '030',
      '02223131',
      38,
      14,
      '4432221',
      3.379514,
      1.828773,
      0,
      1,
      '021121',
      5,
      NULL,
      '10-18-1974',
      NULL,
      196,
      7,
      9,
      15.785311,
      11.121743,
      27,
      1.002807,
      4,
      9.902039,
      13,
      10.899129,
      NULL,
      8.425154,
      8.807930,
      6,
      NULL,
      6.009450,
      17.997631,
      NULL,
      5,
      7.852993,
      113.851084,
      8,
      0,
      25,
      26,
      NULL,
      141,
      NULL,
      147,
      ' 9- 8-1989',
      26,
      7.231909,
      18.427522,
      9.977505,
      NULL,
      42,
      ' 1-15-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      78.020870,
      11.452578,
      2,
      2,
      3.129070,
      7,
      ' 3- 8-2000',
      0,
      1.549551,
      59,
      3.438905,
      1,
      39.823173,
      1,
      NULL,
      64,
      NULL,
      NULL,
      NULL,
      '11-24-1985',
      18.408059,
      17.706174,
      NULL,
      69,
      13.318685,
      20,
      26,
      4,
      55.580679,
      64,
      30.482205,
      66,
      ' 8-12-1982',
      19,
      NULL,
      15,
      NULL,
      41.327273,
      49,
      7,
      ' 5- 9-1992',
      9.071849,
      4.327984,
      ' 0-12-2003',
      3,
      11,
      20.356409,
      NULL,
      NULL,
      6,
      3.540666,
      13,
      1.218015,
      100,
      NULL,
      0,
      9.398681,
      28.358679,
      0,
      3,
      1,
      0.648152,
      '10-13-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      6.811484,
      51.375983,
      ' 7-23-1989',
      NULL,
      NULL,
      NULL,
      25,
      NULL,
      4.833753,
      ' 5-18-1985',
      11.066498,
      8.574609,
      ' 2-18-1995',
      25,
      74,
      '10-26-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      10.083377,
      ' 9-16-1995',
      53,
      NULL,
      NULL,
      ' 2-12-1978',
      1,
      76.117967,
      '11-17-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


