set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9024643';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1012',
      '23132141',
      '40102112',
      NULL,
      NULL,
      '13311331',
      '03221222',
      '22324000',
      '33300240',
      '14014000',
      '24300243',
      '31112014',
      '01012432',
      '14223110',
      '41243234',
      '11133223',
      '10121242',
      '02240424',
      '24411441',
      '30212112',
      '34201301',
      NULL,
      '10114013',
      '41024130',
      NULL,
      '03340013',
      '22341403',
      '13221434',
      '24421440',
      '40004240',
      '01404414',
      '31013220',
      NULL,
      '12203341',
      '02412042',
      '44012114',
      '14303113',
      '33213121',
      '12004212',
      NULL,
      '02032040',
      '24201414',
      '22004402',
      '33110303',
      '10342230',
      NULL,
      NULL,
      NULL,
      NULL,
      '4242104',
      NULL,
      1.261579,
      2,
      NULL,
      NULL,
      2.971561,
      ' 6-25-1982',
      '11-10-2003',
      45,
      NULL,
      13,
      8,
      1,
      4,
      17,
      9,
      23,
      12,
      17.405187,
      NULL,
      NULL,
      9.810164,
      NULL,
      NULL,
      16,
      NULL,
      NULL,
      NULL,
      14.381255,
      NULL,
      25,
      9,
      NULL,
      NULL,
      68.200317,
      23.044121,
      82.671637,
      86,
      49,
      ' 5-17-1986',
      29,
      6.281968,
      24,
      7.974156,
      NULL,
      30.131268,
      NULL,
      NULL,
      1.889599,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.019706,
      0,
      5.769008,
      NULL,
      0,
      1.376495,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 3-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-27-1992',
      14.575996,
      13,
      0,
      41,
      33,
      16.744475,
      NULL,
      '11-27-1989',
      NULL,
      NULL,
      ' 8- 1-1985',
      6,
      2.795572,
      NULL,
      NULL,
      0.629760,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      22,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      41,
      7.204875,
      NULL,
      '10- 4-1998',
      0,
      144.024234,
      ' 3-18-1983',
      1,
      45.794889,
      9,
      34,
      NULL,
      16,
      1,
      59.691722,
      ' 4-20-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      80,
      27.521515,
      NULL,
      59.334645,
      33,
      22.190680,
      27.126150,
      10.934024,
      78.336129,
      6,
      NULL,
      NULL,
      0,
      80.553166,
      NULL,
      NULL,
      NULL,
      NULL,
      1.254290,
      108,
      NULL,
      NULL,
      164.584063,
      10,
      26.187520,
      NULL,
      0,
      36,
      2,
      NULL,
      0,
      1.671376,
      1,
      1.731805,
      NULL,
      67,
      83.842553,
      NULL,
      24.945099,
      18.905843,
      0,
      11,
      9,
      1.104447,
      0.285699,
      3,
      14.537081,
      1.748835,
      67,
      NULL,
      8,
      1,
      0.345238,
      NULL,
      3.207985,
      15,
      0,
      31,
      71.055802,
      14.268764,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      3,
      NULL,
      88.457360,
      ' 3-28-1975',
      NULL,
      ' 4- 7-1997',
      NULL,
      ' 6-27-1987',
      '10- 9-1974',
      ' 1-28-1983',
      NULL);
commit;
end;
/


