set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9650098';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4411',
      '01404200',
      '11103110',
      '34230022',
      '13302024',
      '41221233',
      '42412114',
      '30202301',
      '24440003',
      '44400111',
      '21322124',
      NULL,
      '34331132',
      NULL,
      NULL,
      '11140342',
      '23314213',
      '41104000',
      '44013034',
      '30424030',
      '24321412',
      NULL,
      '21340301',
      NULL,
      '20004203',
      '31023032',
      '20433420',
      NULL,
      '11014313',
      '01404410',
      '20320202',
      '22300133',
      '31324334',
      '41221421',
      NULL,
      '40403104',
      '00002140',
      '43332130',
      NULL,
      '02120404',
      '00211221',
      NULL,
      '31104134',
      NULL,
      '40341433',
      '412',
      '00',
      16,
      8,
      '3434200',
      1,
      NULL,
      1,
      NULL,
      '223130',
      0.555919,
      ' 0-13-1997',
      ' 6- 8-2003',
      NULL,
      143.375440,
      NULL,
      1.974737,
      NULL,
      7.205247,
      43,
      8.908078,
      NULL,
      7.165638,
      25,
      5,
      29,
      0,
      30.227840,
      17,
      15.059167,
      0.441660,
      NULL,
      13,
      30.109816,
      NULL,
      59.520014,
      7,
      1,
      51.328831,
      17.742897,
      60.273320,
      8.788814,
      154.856356,
      147,
      ' 6- 7-1988',
      44,
      12.042971,
      12,
      NULL,
      2.902407,
      34,
      ' 1-16-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      86,
      9,
      15,
      8,
      14,
      7.399202,
      NULL,
      0,
      3,
      122,
      0,
      0.376220,
      106,
      0.885291,
      1,
      26,
      NULL,
      NULL,
      NULL,
      NULL,
      51.945084,
      100,
      67,
      113.246763,
      106,
      83.087623,
      33,
      64,
      46,
      88,
      NULL,
      80.770470,
      ' 2-26-1995',
      5.024585,
      10,
      22.271674,
      NULL,
      61.302263,
      4.167359,
      9,
      ' 1-19-1982',
      3.759248,
      10,
      '11- 5-1981',
      13.887185,
      3.063523,
      11,
      12,
      7.079640,
      7,
      1,
      7.714914,
      1,
      41.002682,
      0,
      0,
      2.511795,
      0.486445,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.750587,
      3.152016,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      '11- 2-2001',
      NULL,
      ' 7- 4-1976',
      4,
      8,
      ' 8-16-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      19.737465,
      ' 5- 4-1985',
      17.284387,
      33.853570,
      NULL,
      ' 7-22-1988',
      NULL,
      NULL,
      ' 0-13-1983',
      5,
      NULL,
      1.384451,
      NULL,
      ' 7-27-1981',
      25.828339,
      1,
      NULL,
      ' 7- 1-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


